/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.image.metric.internal.hl7.HL7Charset;
import org.aoju.bus.image.metric.internal.hl7.HL7Parser;
import org.aoju.bus.image.metric.internal.hl7.HL7Segment;
import org.xml.sax.SAXException;

public class HL72Xml {
    private URL xslt;
    private boolean indent = false;
    private boolean includeNamespaceDeclaration = false;
    private String charset;

    private static String fname(List<String> argList) throws InternalException {
        int numArgs = argList.size();
        if (numArgs == 0) {
            throw new InternalException("missing");
        }
        if (numArgs > 1) {
            throw new InternalException("too-many");
        }
        return argList.get(0);
    }

    public final void setXSLT(URL xslt) {
        this.xslt = xslt;
    }

    public final void setIndent(boolean indent) {
        this.indent = indent;
    }

    public final void setIncludeNamespaceDeclaration(boolean includeNamespaceDeclaration) {
        this.includeNamespaceDeclaration = includeNamespaceDeclaration;
    }

    public String getCharacterSet() {
        return this.charset;
    }

    public void setCharacterSet(String charset) {
        this.charset = charset;
    }

    public void parse(InputStream is) throws IOException, TransformerConfigurationException, SAXException {
        byte[] buf = new byte[256];
        int len = is.read(buf);
        HL7Segment msh = HL7Segment.parseMSH(buf, buf.length);
        String charsetName = HL7Charset.toCharsetName(msh.getField(17, this.charset));
        InputStreamReader reader = new InputStreamReader((InputStream)new SequenceInputStream(new ByteArrayInputStream(buf, 0, len), is), charsetName);
        TransformerHandler th = this.getTransformerHandler();
        th.getTransformer().setOutputProperty("indent", this.indent ? "yes" : "no");
        th.setResult(new StreamResult(System.out));
        HL7Parser hl7Parser = new HL7Parser(th);
        hl7Parser.setIncludeNamespaceDeclaration(this.includeNamespaceDeclaration);
        hl7Parser.parse(reader);
    }

    private TransformerHandler getTransformerHandler() throws TransformerConfigurationException, IOException {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        if (null == this.xslt) {
            return tf.newTransformerHandler();
        }
        TransformerHandler th = tf.newTransformerHandler(new StreamSource(this.xslt.openStream(), this.xslt.toExternalForm()));
        return th;
    }
}

