/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.metric.Progress;

public class Status {
    public static final int Success = 0;
    public static final int Pending = 65280;
    public static final int PendingWarning = 65281;
    public static final int Cancel = 65024;
    public static final int NoSuchAttribute = 261;
    public static final int InvalidAttributeValue = 262;
    public static final int AttributeListError = 263;
    public static final int ProcessingFailure = 272;
    public static final int DuplicateSOPinstance = 273;
    public static final int NoSuchObjectInstance = 274;
    public static final int NoSuchEventType = 275;
    public static final int NoSuchArgument = 276;
    public static final int InvalidArgumentValue = 277;
    public static final int AttributeValueOutOfRange = 278;
    public static final int InvalidObjectInstance = 279;
    public static final int NoSuchSOPclass = 280;
    public static final int ClassInstanceConflict = 281;
    public static final int MissingAttribute = 288;
    public static final int MissingAttributeValue = 289;
    public static final int SOPclassNotSupported = 290;
    public static final int NoSuchActionType = 291;
    public static final int NotAuthorized = 292;
    public static final int DuplicateInvocation = 528;
    public static final int UnrecognizedOperation = 529;
    public static final int MistypedArgument = 530;
    public static final int ResourceLimitation = 531;
    public static final int OutOfResources = 42752;
    public static final int UnableToCalculateNumberOfMatches = 42753;
    public static final int UnableToPerformSubOperations = 42754;
    public static final int MoveDestinationUnknown = 43009;
    public static final int IdentifierDoesNotMatchSOPClass = 43264;
    public static final int DataSetDoesNotMatchSOPClassError = 43264;
    public static final int OneOrMoreFailures = 45056;
    public static final int CoercionOfDataElements = 45056;
    public static final int ElementsDiscarded = 45062;
    public static final int DataSetDoesNotMatchSOPClassWarning = 45063;
    public static final int UnableToProcess = 49152;
    public static final int CannotUnderstand = 49152;
    private final Progress progress;
    private final List<Attributes> list;
    private volatile int status;
    private String message;

    public Status() {
        this(65280, null, null);
    }

    public Status(Progress progress) {
        this(65280, null, progress);
    }

    public Status(int status, String message, Progress progress) {
        this.status = status;
        this.message = message;
        this.progress = progress;
        this.list = new ArrayList<Attributes>();
    }

    public static Status build(Status dcmState, String timeMessage, Exception e) {
        Status state = dcmState;
        if (null == state) {
            state = new Status(49152, null, null);
        }
        Progress p = state.getProgress();
        int s = state.getStatus();
        StringBuilder msg = new StringBuilder();
        boolean hasFailed = false;
        if (null != p) {
            int failed = p.getNumberOfFailedSuboperations();
            int warning = p.getNumberOfWarningSuboperations();
            int remaining = p.getNumberOfRemainingSuboperations();
            if (failed > 0) {
                hasFailed = true;
                msg.append(String.format("%d/%d operations has failed.", failed, failed + p.getNumberOfCompletedSuboperations()));
            } else if (remaining > 0) {
                msg.append(String.format("%d operations remains. ", remaining));
            } else if (warning > 0) {
                msg.append(String.format("%d operations has a warning status. ", warning));
            }
        }
        if (null != e) {
            hasFailed = true;
            if (msg.length() > 0) {
                msg.append(" ");
            }
            msg.append(e.getLocalizedMessage());
        }
        if (null != p && null != p.getAttributes()) {
            String error = p.getErrorComment();
            if (StringKit.hasText((String)error)) {
                hasFailed = true;
                if (msg.length() > 0) {
                    msg.append("\n");
                }
                msg.append("DICOM error : ");
                msg.append(error);
            }
            if (!Status.isPending(s) && s != -1 && s != 0 && s != 65024) {
                if (msg.length() > 0) {
                    msg.append("\n");
                }
                msg.append("DICOM status : ");
                msg.append(s);
            }
        }
        if (!hasFailed) {
            if (null != timeMessage) {
                msg.append(timeMessage);
            }
        } else if (Status.isPending(s) || s == -1) {
            state.setStatus(49152);
        }
        state.setMessage(msg.toString());
        return state;
    }

    public static boolean isPending(int status) {
        return (status & 0xFF00) == 65280;
    }

    public int getStatus() {
        if (null != this.progress && null != this.progress.getAttributes()) {
            return this.progress.getStatus();
        }
        return this.status;
    }

    public void setList(Attributes attributes) {
        if (null != attributes) {
            this.list.add(attributes);
        }
    }

    public Progress getProgress() {
        return this.progress;
    }

    public List<Attributes> getList() {
        return this.list;
    }

    public String getMessage() {
        return this.message;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Status)) {
            return false;
        }
        Status other = (Status)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        Progress this$progress = this.getProgress();
        Progress other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !this$progress.equals(other$progress)) {
            return false;
        }
        List<Attributes> this$list = this.getList();
        List<Attributes> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Status;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        Progress $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : $progress.hashCode());
        List<Attributes> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "Status(progress=" + String.valueOf(this.getProgress()) + ", list=" + String.valueOf(this.getList()) + ", status=" + this.getStatus() + ", message=" + this.getMessage() + ")";
    }
}

