/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ListIterator;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.data.Value;
import org.aoju.bus.image.galaxy.io.ImageEncodingOptions;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;

public class Fragments
extends ArrayList<Object>
implements Value {
    private final VR vr;
    private final boolean bigEndian;

    public Fragments(VR vr, boolean bigEndian, int initialCapacity) {
        super(initialCapacity);
        this.vr = vr;
        this.bigEndian = bigEndian;
    }

    public final VR vr() {
        return this.vr;
    }

    public final boolean bigEndian() {
        return this.bigEndian;
    }

    @Override
    public String toString() {
        return this.size() + " Fragments";
    }

    @Override
    public boolean add(Object frag) {
        this.add(this.size(), frag);
        return true;
    }

    @Override
    public void add(int index, Object frag) {
        super.add(index, null == frag || frag instanceof byte[] && ((byte[])frag).length == 0 ? NULL : frag);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        for (Object object : c) {
            this.add(index++, object);
        }
        return !c.isEmpty();
    }

    @Override
    public void writeTo(ImageOutputStream out, VR vr) throws IOException {
        for (Object frag : this) {
            out.writeAttribute(-73728, vr, frag, null);
        }
    }

    @Override
    public int calcLength(ImageEncodingOptions encOpts, boolean explicitVR, VR vr) {
        int len = 0;
        for (Object frag : this) {
            len += 8;
            if (frag instanceof Value) {
                len += ((Value)frag).calcLength(encOpts, explicitVR, vr);
                continue;
            }
            len += ((byte[])frag).length + 1 & 0xFFFFFFFE;
        }
        return len;
    }

    @Override
    public int getEncodedLength(ImageEncodingOptions encOpts, boolean explicitVR, VR vr) {
        return -1;
    }

    @Override
    public byte[] toBytes(VR vr, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Fragments other = (Fragments)object;
        if (this.bigEndian != other.bigEndian) {
            return false;
        }
        if (this.vr != other.vr) {
            return false;
        }
        ListIterator e1 = this.listIterator();
        ListIterator e2 = other.listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o2;
            Object o1 = e1.next();
            if (this.itemsEqual(o1, o2 = e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        for (Object e : this) {
            hashCode = 31 * hashCode + this.itemHashCode(e);
        }
        hashCode = 31 * hashCode + (this.bigEndian ? 1231 : 1237);
        hashCode = 31 * hashCode + (null == this.vr ? 0 : this.vr.hashCode());
        return hashCode;
    }

    private boolean itemsEqual(Object o1, Object o2) {
        if (null == o1) {
            return null == o2;
        }
        if (o1 instanceof byte[]) {
            if (o2 instanceof byte[] && ((byte[])o1).length == ((byte[])o2).length) {
                return Arrays.equals((byte[])o1, (byte[])o2);
            }
            return false;
        }
        return o1.equals(o2);
    }

    private int itemHashCode(Object e) {
        if (null == e) {
            return 0;
        }
        if (e instanceof byte[]) {
            return Arrays.hashCode((byte[])e);
        }
        return e.hashCode();
    }
}

