/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ByteKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StreamKit;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.Fragments;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.BulkDataDescriptor;
import org.aoju.bus.image.galaxy.io.ImageEncodingOptions;
import org.aoju.bus.image.galaxy.io.ImageInputHandler;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.nimble.BufferedImages;
import org.aoju.bus.image.nimble.Overlays;
import org.aoju.bus.image.nimble.PaletteColorModel;
import org.aoju.bus.image.nimble.Photometric;
import org.aoju.bus.image.nimble.codec.ExtMemoryOutputStream;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;
import org.aoju.bus.image.nimble.codec.ImageReaderFactory;
import org.aoju.bus.image.nimble.codec.ImageWriterFactory;
import org.aoju.bus.image.nimble.codec.TransferSyntaxType;
import org.aoju.bus.image.nimble.codec.jpeg.PatchJPEGLSImageInputStream;
import org.aoju.bus.image.nimble.codec.jpeg.PatchJPEGLSImageOutputStream;
import org.aoju.bus.image.nimble.stream.ImagePixelInputStream;
import org.aoju.bus.logger.Logger;

public class Transcoder
implements Closeable {
    private static final int BUFFER_SIZE = 8192;
    private static final int[] cmTags = new int[]{2625793, 2625794, 2625795, 2625945, 2626049, 2626050, 2626051, 0x281221, 0x281222, 2626083, 0x282000};
    private final ImageInputStream dis;
    private final String srcTransferSyntax;
    private final TransferSyntaxType srcTransferSyntaxType;
    private final Attributes dataset;
    private boolean retainFileMetaInformation;
    private boolean includeFileMetaInformation;
    private ImageEncodingOptions encOpts = ImageEncodingOptions.DEFAULT;
    private boolean closeInputStream = true;
    private boolean closeOutputStream = true;
    private boolean deleteBulkDataFiles = true;
    private String destTransferSyntax;
    private TransferSyntaxType destTransferSyntaxType;
    private boolean lossyCompression;
    private int maxPixelValueError = -1;
    private int avgPixelValueBlockSize = 1;
    private ImageOutputStream dos;
    private Attributes postPixelData;
    private Handler handler;
    private ImageDescriptor imageDescriptor;
    private ImageDescriptor compressorImageDescriptor;
    private ImagePixelInputStream encapsulatedPixelData;
    private ImageReaderFactory.ImageReaderParam decompressorParam;
    private ImageReader decompressor;
    private ImageReadParam decompressParam;
    private ImageWriterFactory.ImageWriterParam compressorParam;
    private ImageWriter compressor;
    private ImageWriteParam compressParam;
    private ImageReader verifier;
    private ImageReadParam verifyParam;
    private boolean ybr2rgb;
    private boolean palette2rgb;
    private BufferedImage originalBi;
    private BufferedImage bi;
    private BufferedImage bi2;
    private String pixelDataBulkDataURI;
    private byte[] buffer;
    private int bitsCompressed = 0;
    private boolean nullifyPixelData;
    private Attributes fileMetaInformation;
    private final ImageInputHandler imageInputHandler = new ImageInputHandler(){

        @Override
        public void readValue(ImageInputStream dis, Attributes attrs) throws IOException {
            int tag = dis.tag();
            if (dis.level() == 0 && tag == 2145386512) {
                if (Transcoder.this.nullifyPixelData) {
                    Transcoder.this.dataset.setNull(2145386512, dis.vr());
                    Transcoder.this.skipPixelData();
                } else {
                    Transcoder.this.imageDescriptor = new ImageDescriptor(attrs, Transcoder.this.bitsCompressed);
                    Transcoder.this.initOutputStream();
                    Transcoder.this.processPixelData();
                    Transcoder.this.postPixelData = new Attributes(dis.bigEndian());
                }
            } else {
                dis.readValue(dis, attrs);
                if (null != Transcoder.this.postPixelData && dis.level() == 0) {
                    Transcoder.this.postPixelData.addSelected(attrs, attrs.getPrivateCreator(tag), tag);
                }
            }
        }

        @Override
        public void readValue(ImageInputStream dis, Sequence seq) throws IOException {
            dis.readValue(dis, seq);
        }

        @Override
        public void readValue(ImageInputStream dis, Fragments frags) throws IOException {
            if (null == Transcoder.this.dos) {
                if (Transcoder.this.nullifyPixelData) {
                    StreamKit.skipFully((InputStream)dis, (long)dis.length());
                } else {
                    dis.readValue(dis, frags);
                }
            } else {
                int length = dis.length();
                Transcoder.this.dos.writeHeader(-73728, null, length);
                StreamKit.copy((InputStream)dis, (OutputStream)Transcoder.this.dos, (int)length, (byte[])Transcoder.this.buffer());
            }
        }

        @Override
        public void startDataset(ImageInputStream dis) {
        }

        @Override
        public void endDataset(ImageInputStream dis) {
        }
    };

    public Transcoder(File f) throws IOException {
        this(new ImageInputStream(f));
    }

    public Transcoder(InputStream in) throws IOException {
        this(new ImageInputStream(in));
    }

    public Transcoder(InputStream in, String tsuid) throws IOException {
        this(new ImageInputStream(in, tsuid));
    }

    public Transcoder(ImageInputStream dis) throws IOException {
        this.dis = dis;
        dis.readFileMetaInformation();
        dis.setImageInputHandler(this.imageInputHandler);
        this.dataset = new Attributes(dis.bigEndian(), 64);
        this.srcTransferSyntax = dis.getTransferSyntax();
        this.srcTransferSyntaxType = TransferSyntaxType.forUID(this.srcTransferSyntax);
        this.destTransferSyntax = this.srcTransferSyntax;
        this.destTransferSyntaxType = this.srcTransferSyntaxType;
    }

    private static byte[] to16BitsAllocated(byte[] b, int off, int len, byte[] buf, int j0) {
        int i = 0;
        int j = j0;
        while (i < len) {
            buf[j] = b[off + i];
            ++i;
            ++j;
            ++j;
        }
        return buf;
    }

    private static void bgr2rgb(byte[] bs) {
        int i = 0;
        for (int j = 2; j < bs.length; j += 3) {
            byte b = bs[i];
            bs[i] = bs[j];
            bs[j] = b;
            i += 3;
        }
    }

    private static short[] toShortData(DataBuffer db) {
        return db.getDataType() == 2 ? ((DataBufferShort)db).getData() : ((DataBufferUShort)db).getData();
    }

    public void setEncodingOptions(ImageEncodingOptions encOpts) {
        this.encOpts = Objects.requireNonNull(encOpts);
    }

    public void setConcatenateBulkDataFiles(boolean catBlkFiles) {
        this.dis.setConcatenateBulkDataFiles(catBlkFiles);
    }

    public void setIncludeBulkData(ImageInputStream.IncludeBulkData includeBulkData) {
        this.dis.setIncludeBulkData(includeBulkData);
    }

    public void setBulkDataDescriptor(BulkDataDescriptor bulkDataDescriptor) {
        this.dis.setBulkDataDescriptor(bulkDataDescriptor);
    }

    public void setBulkDataDirectory(File blkDirectory) {
        this.dis.setBulkDataDirectory(blkDirectory);
    }

    public boolean isCloseInputStream() {
        return this.closeInputStream;
    }

    public void setCloseInputStream(boolean closeInputStream) {
        this.closeInputStream = closeInputStream;
    }

    public boolean isCloseOutputStream() {
        return this.closeOutputStream;
    }

    public void setCloseOutputStream(boolean closeOutputStream) {
        this.closeOutputStream = closeOutputStream;
    }

    public boolean isDeleteBulkDataFiles() {
        return this.deleteBulkDataFiles;
    }

    public void setDeleteBulkDataFiles(boolean deleteBulkDataFiles) {
        this.deleteBulkDataFiles = deleteBulkDataFiles;
    }

    public boolean isIncludeFileMetaInformation() {
        return this.includeFileMetaInformation;
    }

    public void setIncludeFileMetaInformation(boolean includeFileMetaInformation) {
        this.includeFileMetaInformation = includeFileMetaInformation;
    }

    public boolean isRetainFileMetaInformation() {
        return this.retainFileMetaInformation;
    }

    public void setRetainFileMetaInformation(boolean retainFileMetaInformation) {
        this.retainFileMetaInformation = retainFileMetaInformation;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public String getSourceTransferSyntax() {
        return this.dis.getTransferSyntax();
    }

    public TransferSyntaxType getSourceTransferSyntaxType() {
        return this.srcTransferSyntaxType;
    }

    public String getDestinationTransferSyntax() {
        return this.destTransferSyntax;
    }

    public void setDestinationTransferSyntax(String tsuid) {
        if (tsuid.equals(this.destTransferSyntax)) {
            return;
        }
        this.destTransferSyntaxType = TransferSyntaxType.forUID(tsuid);
        this.lossyCompression = TransferSyntaxType.isLossyCompression(tsuid);
        this.destTransferSyntax = tsuid;
        if (this.srcTransferSyntaxType.isPixeldataEncapsulated()) {
            this.initDecompressor();
        }
        if (this.destTransferSyntaxType.isPixeldataEncapsulated()) {
            this.initCompressor(tsuid);
        }
    }

    public String getPixelDataBulkDataURI() {
        return this.pixelDataBulkDataURI;
    }

    public void setPixelDataBulkDataURI(String pixelDataBulkDataURI) {
        this.pixelDataBulkDataURI = pixelDataBulkDataURI;
    }

    public List<File> getBulkDataFiles() {
        return this.dis.getBulkDataFiles();
    }

    public boolean isNullifyPixelData() {
        return this.nullifyPixelData;
    }

    public void setNullifyPixelData(boolean nullifyPixelData) {
        this.nullifyPixelData = nullifyPixelData;
    }

    public Attributes getFileMetaInformation() {
        return this.fileMetaInformation;
    }

    @Override
    public void close() throws IOException {
        if (null != this.decompressor) {
            this.decompressor.dispose();
        }
        if (null != this.compressor) {
            this.compressor.dispose();
        }
        if (null != this.verifier) {
            this.verifier.dispose();
        }
        if (this.closeInputStream) {
            IoKit.close((Closeable)this.dis);
        }
        if (this.deleteBulkDataFiles) {
            for (File tmpFile : this.dis.getBulkDataFiles()) {
                tmpFile.delete();
            }
        }
        if (this.closeOutputStream && null != this.dos) {
            this.dos.close();
        }
    }

    public void transcode(Handler handler) throws IOException {
        this.handler = handler;
        this.dis.readAttributes(this.dataset, -1, -1);
        if (null == this.dos) {
            if (null != this.compressor) {
                this.destTransferSyntax = "1.2.840.10008.1.2.1";
                this.destTransferSyntaxType = TransferSyntaxType.NATIVE;
                this.lossyCompression = false;
            }
            this.initOutputStream();
            this.writeDataset();
        } else if (null != this.postPixelData) {
            this.dos.writeDataset(null, this.postPixelData);
        }
    }

    private void initDecompressor() {
        this.decompressorParam = ImageReaderFactory.getImageReaderParam(this.srcTransferSyntax);
        if (null == this.decompressorParam) {
            throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + this.srcTransferSyntax);
        }
        this.decompressor = ImageReaderFactory.getImageReader(this.decompressorParam);
        Logger.debug((String)"Decompressor: {}", (Object[])new Object[]{this.decompressor.getClass().getName()});
        this.decompressParam = this.decompressor.getDefaultReadParam();
    }

    private void processPixelData() throws IOException {
        VR vr;
        if (null != this.decompressor) {
            this.initEncapsulatedPixelData();
        }
        if (null != this.compressor) {
            vr = VR.OB;
            this.compressPixelData();
        } else if (null != this.decompressor) {
            vr = VR.OW;
            this.decompressPixelData();
        } else {
            vr = this.dis.vr();
            this.copyPixelData();
        }
        this.setPixelDataBulkData(vr);
    }

    private void initEncapsulatedPixelData() throws IOException {
        this.encapsulatedPixelData = new ImagePixelInputStream(this.dis, this.imageDescriptor);
    }

    private void decompressPixelData() throws IOException {
        int length = this.imageDescriptor.getLength();
        int padding = length & 1;
        this.adjustDataset();
        this.writeDataset();
        this.dos.writeHeader(2145386512, VR.OW, length + padding);
        for (int i = 0; i < this.imageDescriptor.getFrames(); ++i) {
            this.decompressFrame(i);
            this.writeFrame();
        }
        if (padding != 0) {
            this.dos.write(0);
        }
    }

    private void initCompressor(String tsuid) {
        this.compressorParam = ImageWriterFactory.getImageWriterParam(tsuid);
        if (null == this.compressorParam) {
            throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + tsuid);
        }
        this.compressor = ImageWriterFactory.getImageWriter(this.compressorParam);
        Logger.debug((String)"Compressor: {}", (Object[])new Object[]{this.compressor.getClass().getName()});
        this.compressParam = this.compressor.getDefaultWriteParam();
        this.setCompressParams(this.compressorParam.getImageWriteParams());
    }

    private void copyPixelData() throws IOException {
        int length = this.dis.length();
        this.writeDataset();
        this.dos.writeHeader(2145386512, this.dis.vr(), length);
        if (length == -1) {
            this.dis.readValue(this.dis, this.dataset);
            this.dos.writeHeader(-73507, null, 0);
        } else if (this.dis.bigEndian() == this.dos.isBigEndian()) {
            StreamKit.copy((InputStream)this.dis, (OutputStream)this.dos, (int)length, (byte[])this.buffer());
        } else {
            StreamKit.copy((InputStream)this.dis, (OutputStream)this.dos, (int)length, (int)this.dis.vr().numEndianBytes(), (byte[])this.buffer());
        }
    }

    private void compressPixelData() throws IOException {
        int padding = this.dis.length() - this.imageDescriptor.getLength();
        for (int i = 0; i < this.imageDescriptor.getFrames(); ++i) {
            if (null == this.decompressor) {
                this.readFrame();
            } else {
                this.decompressFrame(i);
            }
            if (i == 0) {
                this.extractEmbeddedOverlays();
                this.adjustDataset();
                this.writeDataset();
                this.dos.writeHeader(2145386512, VR.OB, -1);
                this.dos.writeHeader(-73728, null, 0);
            }
            this.nullifyUnusedBits();
            this.bi = this.palette2rgb ? BufferedImages.convertPalettetoRGB(this.originalBi, this.bi) : (this.ybr2rgb ? BufferedImages.convertYBRtoRGB(this.originalBi, this.bi) : this.originalBi);
            this.compressFrame(i);
        }
        this.dis.skipFully(padding);
        this.dos.writeHeader(-73507, null, 0);
    }

    private void setPixelDataBulkData(VR vr) {
        if (null != this.pixelDataBulkDataURI) {
            this.dataset.setValue(2145386512, vr, new BulkData(null, this.pixelDataBulkDataURI, false));
        }
    }

    public void setCompressParams(Property ... imageWriteParams) {
        if (null == this.compressorParam) {
            return;
        }
        for (Property property : imageWriteParams) {
            String name = property.getName();
            if (name.equals("maxPixelValueError")) {
                this.maxPixelValueError = ((Number)property.getValue()).intValue();
                continue;
            }
            if (name.equals("avgPixelValueBlockSize")) {
                this.avgPixelValueBlockSize = ((Number)property.getValue()).intValue();
                continue;
            }
            if (name.equals("bitsCompressed")) {
                this.bitsCompressed = ((Number)property.getValue()).intValue();
                continue;
            }
            if (this.compressParam.getCompressionMode() != 2) {
                this.compressParam.setCompressionMode(2);
            }
            property.setAt(this.compressParam);
        }
        if (this.maxPixelValueError >= 0) {
            ImageReaderFactory.ImageReaderParam readerParam = ImageReaderFactory.getImageReaderParam(this.destTransferSyntax);
            if (null == readerParam) {
                throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + this.destTransferSyntax);
            }
            this.verifier = ImageReaderFactory.getImageReader(readerParam);
            this.verifyParam = this.verifier.getDefaultReadParam();
            Logger.debug((String)"Verifier: {}", (Object[])new Object[]{this.verifier.getClass().getName()});
        }
    }

    private Photometric pmiForCompression(Photometric pmi) {
        return pmi.isYBR() && this.destTransferSyntaxType == TransferSyntaxType.JPEG_LOSSLESS ? Photometric.RGB : pmi;
    }

    private void extractEmbeddedOverlays() {
        for (int gg0000 : this.imageDescriptor.getEmbeddedOverlays()) {
            int ovlyRow = this.dataset.getInt(0x60000010 | gg0000, 0);
            int ovlyColumns = this.dataset.getInt(0x60000011 | gg0000, 0);
            int ovlyBitPosition = this.dataset.getInt(0x60000102 | gg0000, 0);
            int mask = 1 << ovlyBitPosition;
            int ovlyLength = ovlyRow * ovlyColumns;
            byte[] ovlyData = new byte[(ovlyLength + 7 >>> 3) + 1 & 0xFFFFFFFE];
            Overlays.extractFromPixeldata(this.originalBi.getRaster(), mask, ovlyData, 0, ovlyLength);
            this.dataset.setInt(0x60000100 | gg0000, VR.US, 1);
            this.dataset.setInt(0x60000102 | gg0000, VR.US, 0);
            this.dataset.setBytes(0x60003000 | gg0000, VR.OB, ovlyData);
            Logger.debug((String)"Extracted embedded overlay #{} from bit #{}", (Object[])new Object[]{(gg0000 >>> 17) + 1, ovlyBitPosition});
        }
    }

    private void skipPixelData() throws IOException {
        int length = this.dis.length();
        if (length == -1) {
            this.dis.readValue(this.dis, this.dataset);
        } else {
            StreamKit.skipFully((InputStream)this.dis, (long)length);
        }
    }

    private void nullifyUnusedBits(short[] data) {
        int mask = (1 << this.imageDescriptor.getBitsStored()) - 1;
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = (short)(data[n] & mask);
        }
    }

    private void adjustDataset() {
        Photometric pmi = this.imageDescriptor.getPhotometric();
        if (null != this.decompressor) {
            if (this.imageDescriptor.getSamples() == 3) {
                if (pmi.isYBR() && TransferSyntaxType.isYBRCompression(this.srcTransferSyntax)) {
                    pmi = Photometric.RGB;
                    this.dataset.setString(2621444, VR.CS, pmi.toString());
                }
                this.dataset.setInt(2621446, VR.US, this.srcTransferSyntaxType.getPlanarConfiguration());
            } else if (this.srcTransferSyntaxType.adjustBitsStoredTo12(this.dataset)) {
                Logger.info((String)"Adjust invalid Bits Stored: {} of {} to 12", (Object[])new Object[]{this.imageDescriptor.getBitsStored(), this.srcTransferSyntaxType});
            }
        }
        if (null != this.compressor) {
            if (pmi == Photometric.PALETTE_COLOR && this.lossyCompression) {
                this.palette2rgb = true;
                this.dataset.removeSelected(cmTags);
                this.dataset.setInt(0x280002, VR.US, 3);
                this.dataset.setInt(2621696, VR.US, 8);
                this.dataset.setInt(2621697, VR.US, 8);
                this.dataset.setInt(2621698, VR.US, 7);
                pmi = Photometric.RGB;
                Logger.warn((String)"Converting PALETTE_COLOR model into a lossy format is not recommended, prefer a lossless format", (Object[])new Object[0]);
            } else if (pmi.isSubSampled() && !this.srcTransferSyntaxType.isPixeldataEncapsulated() || pmi == Photometric.YBR_FULL && TransferSyntaxType.isYBRCompression(this.destTransferSyntax)) {
                this.ybr2rgb = true;
                pmi = Photometric.RGB;
                Logger.debug((String)"Conversion to an RGB color model is required before compression.", (Object[])new Object[0]);
            } else if (this.destTransferSyntaxType.adjustBitsStoredTo12(this.dataset)) {
                Logger.debug((String)"Adjust Bits Stored: {} for {} to 12", (Object[])new Object[]{this.imageDescriptor.getBitsStored(), this.destTransferSyntaxType});
            }
            this.dataset.setString(2621444, VR.CS, this.pmiForCompression(pmi).toString());
            this.compressorImageDescriptor = new ImageDescriptor(this.dataset, this.bitsCompressed);
            pmi = pmi.compress(this.destTransferSyntax);
            this.dataset.setString(2621444, VR.CS, pmi.toString());
            if (this.dataset.getInt(0x280002, 1) > 1) {
                this.dataset.setInt(2621446, VR.US, this.destTransferSyntaxType.getPlanarConfiguration());
            }
            if (this.lossyCompression) {
                this.dataset.setString(2629904, VR.CS, "01");
                if ("jpeg2000-cv".equals(this.compressorParam.formatName)) {
                    for (Property p : this.compressorParam.getImageWriteParams()) {
                        if (!"compressionRatiofactor".equals(p.getName())) continue;
                        this.dataset.setFloat(0x282112, VR.DS, ((Double)p.getValue()).floatValue());
                        break;
                    }
                }
            }
        }
    }

    private BufferedImage decompressFrame(int frameIndex) throws IOException {
        this.decompressor.setInput(null != this.decompressorParam.patchJPEGLS ? new PatchJPEGLSImageInputStream(this.encapsulatedPixelData, this.decompressorParam.patchJPEGLS) : this.encapsulatedPixelData);
        if (this.srcTransferSyntaxType == TransferSyntaxType.RLE) {
            this.initBufferedImage();
        }
        this.decompressParam.setDestination(this.originalBi);
        long start = System.currentTimeMillis();
        this.originalBi = this.adjustColorModel(this.decompressor.read(0, this.decompressParam));
        long end = System.currentTimeMillis();
        Logger.debug((String)"Decompressed frame #{} in {} ms, ratio 1:{}", (Object[])new Object[]{frameIndex + 1, end - start, Float.valueOf((float)this.imageDescriptor.getFrameLength() / (float)this.encapsulatedPixelData.getStreamPosition())});
        this.encapsulatedPixelData.seekNextFrame();
        return this.originalBi;
    }

    private BufferedImage adjustColorModel(BufferedImage bi) {
        Photometric pmi = this.imageDescriptor.getPhotometric();
        if (pmi == Photometric.PALETTE_COLOR && !(bi.getColorModel() instanceof PaletteColorModel)) {
            ColorModel cm;
            if (null != this.originalBi) {
                cm = this.originalBi.getColorModel();
            } else {
                int bitsStored = Math.min(this.imageDescriptor.getBitsStored(), this.destTransferSyntaxType.getMaxBitsStored());
                int dataType = bi.getSampleModel().getDataType();
                cm = pmi.createColorModel(bitsStored, dataType, this.dataset);
            }
            bi = new BufferedImage(cm, bi.getRaster(), false, null);
        }
        return bi;
    }

    private void compressFrame(int frameIndex) throws IOException {
        ExtMemoryOutputStream ios = new ExtMemoryOutputStream(this.compressorImageDescriptor);
        this.compressor.setOutput(null != this.compressorParam.patchJPEGLS ? new PatchJPEGLSImageOutputStream(ios, this.compressorParam.patchJPEGLS) : ios);
        long start = System.currentTimeMillis();
        this.compressor.write(null, new IIOImage(this.bi, null, null), this.compressParam);
        long end = System.currentTimeMillis();
        int length = (int)ios.getStreamPosition();
        Logger.debug((String)"Compressed frame #{} in {} ms, ratio {}:1", (Object[])new Object[]{frameIndex + 1, end - start, Float.valueOf((float)this.imageDescriptor.getFrameLength() / (float)length)});
        this.verify(ios, frameIndex);
        if ((length & 1) != 0) {
            ios.write(0);
            ++length;
        }
        this.dos.writeHeader(-73728, null, length);
        ios.setOutputStream(this.dos);
        ios.flush();
    }

    private void readFrame() throws IOException {
        this.initBufferedImage();
        WritableRaster raster = this.originalBi.getRaster();
        DataBuffer dataBuffer = raster.getDataBuffer();
        switch (dataBuffer.getDataType()) {
            case 2: {
                this.readFully(((DataBufferShort)dataBuffer).getData());
                break;
            }
            case 1: {
                this.readFully(((DataBufferUShort)dataBuffer).getData());
                break;
            }
            case 0: {
                this.readFully(((DataBufferByte)dataBuffer).getBankData());
            }
        }
    }

    private void readFully(byte[][] bb) throws IOException {
        for (byte[] b : bb) {
            this.dis.readFully(b);
        }
        if (this.dis.bigEndian() && this.dis.vr() == VR.OW) {
            ByteKit.swapShorts((byte[][])bb);
        }
    }

    private void readFully(short[] s) throws IOException {
        int nelts;
        int off = 0;
        byte[] b = this.buffer();
        for (int len = s.length; len > 0; len -= nelts) {
            nelts = Math.min(len, b.length / 2);
            this.dis.readFully(b, 0, nelts * 2);
            this.toShorts(b, s, off, nelts, this.dis.bigEndian());
            off += nelts;
        }
    }

    private void toShorts(byte[] b, short[] s, int off, int len, boolean bigEndian) {
        int boff = 0;
        if (bigEndian) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                s[off + j] = (short)(b0 << 8 | b1);
                boff += 2;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 1];
                int b1 = b[boff] & 0xFF;
                s[off + j] = (short)(b0 << 8 | b1);
                boff += 2;
            }
        }
    }

    private byte[] buffer() {
        if (null == this.buffer) {
            this.buffer = new byte[8192];
        }
        return this.buffer;
    }

    private void writeFrame() throws IOException {
        WritableRaster raster = this.originalBi.getRaster();
        SampleModel sm = raster.getSampleModel();
        DataBuffer db = raster.getDataBuffer();
        switch (db.getDataType()) {
            case 0: {
                this.write(sm, ((DataBufferByte)db).getBankData());
                break;
            }
            case 1: {
                this.write(sm, ((DataBufferUShort)db).getData());
                break;
            }
            case 2: {
                this.write(sm, ((DataBufferShort)db).getData());
                break;
            }
            case 3: {
                this.write(sm, ((DataBufferInt)db).getData());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Datatype: " + db.getDataType());
            }
        }
    }

    private void nullifyUnusedBits() {
        if (this.imageDescriptor.getBitsStored() < this.imageDescriptor.getBitsAllocated()) {
            DataBuffer db = this.originalBi.getRaster().getDataBuffer();
            switch (db.getDataType()) {
                case 1: {
                    this.nullifyUnusedBits(((DataBufferUShort)db).getData());
                    break;
                }
                case 2: {
                    this.extendSignUnusedBits(((DataBufferShort)db).getData());
                }
            }
        }
    }

    private void extendSignUnusedBits(short[] data) {
        int unused = 32 - this.imageDescriptor.getBitsStored();
        for (int i = 0; i < data.length; ++i) {
            data[i] = (short)(data[i] << unused >> unused);
        }
    }

    private void write(SampleModel sm, byte[][] bankData) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        ComponentSampleModel csm = (ComponentSampleModel)sm;
        int len = w * csm.getPixelStride();
        int stride = csm.getScanlineStride();
        if (csm.getBandOffsets()[0] != 0) {
            Transcoder.bgr2rgb(bankData[0]);
        }
        if (this.imageDescriptor.getBitsAllocated() == 16) {
            byte[] buf = new byte[len << 1];
            int j0 = this.dos.isBigEndian() ? 1 : 0;
            for (byte[] b : bankData) {
                int y = 0;
                int off = 0;
                while (y < h) {
                    this.dos.write(Transcoder.to16BitsAllocated(b, off, len, buf, j0));
                    ++y;
                    off += stride;
                }
            }
        } else {
            for (byte[] b : bankData) {
                int y = 0;
                int off = 0;
                while (y < h) {
                    this.dos.write(b, off, len);
                    ++y;
                    off += stride;
                }
            }
        }
    }

    private void write(SampleModel sm, short[] data) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        int stride = ((ComponentSampleModel)sm).getScanlineStride();
        byte[] b = new byte[w * 2];
        for (int y = 0; y < h; ++y) {
            int i = 0;
            int j = y * stride;
            while (i < b.length) {
                short s = data[j++];
                b[i++] = (byte)s;
                b[i++] = (byte)(s >> 8);
            }
            this.dos.write(b);
        }
    }

    private void write(SampleModel sm, int[] data) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        int stride = ((SinglePixelPackedSampleModel)sm).getScanlineStride();
        byte[] b = new byte[w * 3];
        for (int y = 0; y < h; ++y) {
            int i = 0;
            int j = y * stride;
            while (i < b.length) {
                int s = data[j++];
                b[i++] = (byte)(s >> 16);
                b[i++] = (byte)(s >> 8);
                b[i++] = (byte)s;
            }
            this.dos.write(b);
        }
    }

    private void initOutputStream() throws IOException {
        this.dos = new ImageOutputStream(this.handler.newOutputStream(this, this.dataset), this.includeFileMetaInformation ? "1.2.840.10008.1.2.1" : this.destTransferSyntax);
        this.dos.setEncodingOptions(this.encOpts);
    }

    private void writeDataset() throws IOException {
        Attributes fmi = null;
        if (this.includeFileMetaInformation) {
            if (this.retainFileMetaInformation) {
                fmi = this.dis.getFileMetaInformation();
            }
            if (null == fmi) {
                fmi = this.dataset.createFileMetaInformation(this.destTransferSyntax);
            } else {
                fmi.setString(131088, VR.UI, this.destTransferSyntax);
            }
        }
        this.dos.writeDataset(fmi, this.dataset);
        this.fileMetaInformation = fmi;
    }

    private void initBufferedImage() {
        if (null != this.originalBi) {
            return;
        }
        int rows = this.imageDescriptor.getRows();
        int cols = this.imageDescriptor.getColumns();
        int samples = this.imageDescriptor.getSamples();
        int bitsAllocated = this.imageDescriptor.getBitsAllocated();
        int bitsStored = Math.min(this.imageDescriptor.getBitsStored(), this.destTransferSyntaxType.getMaxBitsStored());
        boolean signed = this.imageDescriptor.isSigned() && this.destTransferSyntaxType.canEncodeSigned();
        boolean banded = this.imageDescriptor.isBanded() || this.srcTransferSyntaxType == TransferSyntaxType.RLE;
        Photometric pmi = this.imageDescriptor.getPhotometric();
        int dataType = bitsAllocated > 8 ? (signed ? 2 : 1) : 0;
        ColorModel cm = pmi.createColorModel(bitsStored, dataType, this.dataset);
        SampleModel sm = pmi.createSampleModel(dataType, cols, rows, samples, banded);
        WritableRaster raster = Raster.createWritableRaster(sm, null);
        this.originalBi = new BufferedImage(cm, raster, false, null);
    }

    private void verify(javax.imageio.stream.ImageOutputStream cache, int index) throws IOException {
        if (null == this.verifier) {
            return;
        }
        long prevStreamPosition = cache.getStreamPosition();
        int prevBitOffset = cache.getBitOffset();
        cache.seek(0L);
        this.verifier.setInput(cache);
        this.verifyParam.setDestination(this.bi2);
        long start = System.currentTimeMillis();
        this.bi2 = this.verifier.read(0, this.verifyParam);
        int maxDiff = this.maxDiff(this.bi.getRaster(), this.bi2.getRaster());
        long end = System.currentTimeMillis();
        Logger.debug((String)"Verified compressed frame #{} in {} ms - max pixel value error: {}", (Object[])new Object[]{index + 1, end - start, maxDiff});
        if (maxDiff > this.maxPixelValueError) {
            throw new InternalException("Decompressed pixel data differs up to " + maxDiff + " from original pixel data" + maxDiff);
        }
        cache.seek(prevStreamPosition);
        cache.setBitOffset(prevBitOffset);
    }

    private int maxDiff(WritableRaster raster, WritableRaster raster2) {
        ComponentSampleModel csm = (ComponentSampleModel)raster.getSampleModel();
        ComponentSampleModel csm2 = (ComponentSampleModel)raster2.getSampleModel();
        DataBuffer db = raster.getDataBuffer();
        DataBuffer db2 = raster2.getDataBuffer();
        int blockSize = this.avgPixelValueBlockSize;
        if (blockSize > 1) {
            int w = csm.getWidth();
            int h = csm.getHeight();
            int maxY = (h / blockSize - 1) * blockSize;
            int maxX = (w / blockSize - 1) * blockSize;
            int[] samples = new int[blockSize * blockSize];
            int maxDiff = 0;
            for (int b = 0; b < csm.getNumBands(); ++b) {
                for (int y = 0; y < maxY; y += blockSize) {
                    for (int x = 0; x < maxX; x += blockSize) {
                        int diff = Math.abs(this.sum(csm.getSamples(x, y, blockSize, blockSize, b, samples, db)) - this.sum(csm2.getSamples(x, y, blockSize, blockSize, b, samples, db2)));
                        if (maxDiff >= diff) continue;
                        maxDiff = diff;
                    }
                }
            }
            return maxDiff / samples.length;
        }
        return db.getDataType() == 0 ? this.maxDiff(csm, ((DataBufferByte)db).getBankData(), csm2, ((DataBufferByte)db2).getBankData()) : this.maxDiff(csm, Transcoder.toShortData(db), csm2, Transcoder.toShortData(db2));
    }

    private int sum(int[] samples) {
        int sum = 0;
        for (int sample : samples) {
            sum += sample;
        }
        return sum;
    }

    private int maxDiff(ComponentSampleModel csm, short[] data, ComponentSampleModel csm2, short[] data2) {
        int w = csm.getWidth() * csm.getPixelStride();
        int h = csm.getHeight();
        int stride = csm.getScanlineStride();
        int stride2 = csm2.getScanlineStride();
        int maxDiff = 0;
        for (int y = 0; y < h; ++y) {
            int j = w;
            int i = y * stride;
            int i2 = y * stride2;
            while (j-- > 0) {
                int diff = Math.abs(data[i] - data2[i2]);
                if (maxDiff < diff) {
                    maxDiff = diff;
                }
                ++i;
                ++i2;
            }
        }
        return maxDiff;
    }

    private int maxDiff(ComponentSampleModel csm, byte[][] banks, ComponentSampleModel csm2, byte[][] banks2) {
        int w = csm.getWidth();
        int h = csm.getHeight();
        int bands = csm.getNumBands();
        int stride = csm.getScanlineStride();
        int pixelStride = csm.getPixelStride();
        int[] bankIndices = csm.getBankIndices();
        int[] bandOffsets = csm.getBandOffsets();
        int stride2 = csm2.getScanlineStride();
        int pixelStride2 = csm2.getPixelStride();
        int[] bankIndices2 = csm2.getBankIndices();
        int[] bandOffsets2 = csm2.getBandOffsets();
        int maxDiff = 0;
        for (int b = 0; b < bands; ++b) {
            byte[] bank = banks[bankIndices[b]];
            byte[] bank2 = banks2[bankIndices2[b]];
            int off = bandOffsets[b];
            int off2 = bandOffsets2[b];
            for (int y = 0; y < h; ++y) {
                int x = w;
                int i = y * stride + off;
                int i2 = y * stride2 + off2;
                while (x-- > 0) {
                    int diff = Math.abs(bank[i] - bank2[i2]);
                    if (maxDiff < diff) {
                        maxDiff = diff;
                    }
                    i += pixelStride;
                    i2 += pixelStride2;
                }
            }
        }
        return maxDiff;
    }

    public static interface Handler {
        public OutputStream newOutputStream(Transcoder var1, Attributes var2) throws IOException;
    }
}

