/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.aoju.bus.image.nimble.Photometric;
import org.aoju.bus.image.nimble.codec.BytesWithImageDescriptor;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;
import org.aoju.bus.image.nimble.opencv.ImageCV;
import org.aoju.bus.image.nimble.opencv.ImageConversion;
import org.aoju.bus.image.nimble.opencv.JPEGImageWriteParam;
import org.aoju.bus.image.nimble.opencv.NativeImageReader;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.imgcodecs.Imgcodecs;

public class NativeJPEGImageWriter
extends ImageWriter {
    NativeJPEGImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    private static int getCodecColorSpace(Photometric pi) {
        if (Photometric.MONOCHROME1 == pi) {
            return 2;
        }
        if (Photometric.MONOCHROME2 == pi) {
            return 3;
        }
        if (Photometric.RGB == pi) {
            return 5;
        }
        if (Photometric.YBR_FULL == pi) {
            return 9;
        }
        if (Photometric.YBR_FULL_422 == pi) {
            return 10;
        }
        if (Photometric.YBR_PARTIAL_422 == pi) {
            return 11;
        }
        return 0;
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new JPEGImageWriteParam(this.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (null == this.output) {
            throw new IllegalStateException("input cannot be null");
        }
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("input is not an ImageInputStream!");
        }
        ImageOutputStream stream = (ImageOutputStream)this.output;
        stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)param;
        if (!(stream instanceof BytesWithImageDescriptor)) {
            throw new IllegalArgumentException("stream does not implement BytesWithImageImageDescriptor!");
        }
        ImageDescriptor desc = ((BytesWithImageDescriptor)((Object)stream)).getImageDescriptor();
        Photometric pi = desc.getPhotometric();
        if (jpegParams.isCompressionLossless() && (Photometric.YBR_FULL_422 == pi || Photometric.YBR_PARTIAL_422 == pi || Photometric.YBR_PARTIAL_420 == pi || Photometric.YBR_ICT == pi || Photometric.YBR_RCT == pi)) {
            throw new IllegalArgumentException("True lossless encoder: Photometric interpretation is not supported: " + String.valueOf((Object)pi));
        }
        int epi = NativeJPEGImageWriter.getCodecColorSpace(pi);
        RenderedImage renderedImage = image.getRenderedImage();
        Mat buf = null;
        MatOfInt dicomParams = null;
        try {
            ImageCV mat = null;
            try {
                mat = ImageConversion.toMat(renderedImage, param.getSourceRegion(), false);
                int cvType = mat.type();
                int channels = CvType.channels((int)cvType);
                boolean signed = desc.isSigned();
                int dcmFlags = signed ? 1 : 0;
                int[] params = new int[15];
                params[0] = -1;
                params[1] = dcmFlags;
                params[2] = mat.width();
                params[3] = mat.height();
                params[4] = 1;
                params[5] = channels;
                params[6] = desc.getBitsCompressed();
                params[7] = 2;
                params[9] = epi;
                params[10] = jpegParams.getMode();
                params[13] = (int)(jpegParams.getCompressionQuality() * 100.0f);
                params[14] = jpegParams.getPrediction();
                params[15] = jpegParams.getPointTransform();
                dicomParams = new MatOfInt(params);
                buf = Imgcodecs.dicomJpgWrite((Mat)mat, (MatOfInt)dicomParams, (String)"");
                if (buf.empty()) {
                    throw new IIOException("Native JPEG encoding error: null image");
                }
            }
            finally {
                if (null != mat) {
                    mat.release();
                }
            }
            byte[] bSrcData = new byte[buf.width() * buf.height() * (int)buf.elemSize()];
            buf.get(0, 0, bSrcData);
            stream.write(bSrcData);
        }
        catch (Throwable t) {
            try {
                throw new IIOException("Native JPEG encoding error", t);
            }
            catch (Throwable throwable) {
                NativeImageReader.closeMat(dicomParams);
                NativeImageReader.closeMat(buf);
                throw throwable;
            }
        }
        NativeImageReader.closeMat((Mat)dicomParams);
        NativeImageReader.closeMat(buf);
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }
}

