/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.image.Format;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.logger.Logger;

public class Dcm2String
extends SimpleFileVisitor<Path> {
    private final Format format;
    private final Attributes cliAttrs;

    public Dcm2String(Format format, Attributes cliAttrs) {
        this.format = format;
        this.cliAttrs = cliAttrs;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
        try (ImageInputStream dis = new ImageInputStream(path.toFile());){
            Attributes dataset = dis.readDataset(-1, -1);
            dataset.addAll(this.cliAttrs);
            Logger.error((String)this.format.format(dataset), (Object[])new Object[0]);
        }
        catch (IOException e) {
            Logger.error((String)("Failed to parse DICOM file " + String.valueOf(path)), (Object[])new Object[0]);
            throw new InternalException((Throwable)e);
        }
        return FileVisitResult.CONTINUE;
    }
}

