/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.DirReader;
import org.aoju.bus.image.galaxy.DirWriter;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageEncodingOptions;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.media.RecordFactory;
import org.aoju.bus.image.galaxy.media.RecordType;
import org.aoju.bus.logger.Logger;

public class DcmDir {
    private static final int DEFAULT_WIDTH = 78;
    private static final ElementDictionary DICT = ElementDictionary.getStandardElementDictionary();
    private final FilesetInfo fsInfo = new FilesetInfo();
    private boolean inUse;
    private int width = 78;
    private ImageEncodingOptions encOpts = ImageEncodingOptions.DEFAULT;
    private boolean origSeqLength;
    private boolean checkDuplicate;
    private File file;
    private DirReader in;
    private DirWriter out;
    private RecordFactory recFact;
    private String csv;
    private String recordConfig;
    private char delim;
    private char quote;

    private int readCSVFile(int num) throws Exception {
        if (null != this.recordConfig) {
            this.loadCustomConfiguration();
        }
        try (BufferedReader br = new BufferedReader(new FileReader(this.csv));){
            String nextLine;
            CSVParser parser = new CSVParser(this.delim, this.quote, br.readLine());
            while (null != (nextLine = br.readLine())) {
                this.checkOut();
                this.checkRecordFactory();
                Attributes dataset = parser.toDataset(nextLine);
                if (null == dataset) continue;
                String iuid = dataset.getString(524312);
                char prompt = '.';
                Attributes fmi = null;
                if (null != iuid) {
                    fmi = dataset.createFileMetaInformation("1.2.840.10008.1.2");
                    prompt = 'F';
                }
                num = this.addRecords(dataset, num, null, prompt, iuid, fmi);
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(File f, File bak) throws IOException {
        File tmp = File.createTempFile("DICOMDIR", null, f.getParentFile());
        DirReader r = new DirReader(f);
        try {
            this.fsInfo.setFilesetUID(r.getFileSetUID());
            this.fsInfo.setFilesetID(r.getFileSetID());
            this.fsInfo.setDescriptorFile(r.getDescriptorFile());
            this.fsInfo.setDescriptorFileCharset(r.getDescriptorFileCharacterSet());
            this.create(tmp);
            this.copyFrom(r);
        }
        finally {
            this.close();
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        bak.delete();
        this.rename(f, bak);
        this.rename(tmp, f);
    }

    private void rename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException(MessageFormat.format("failed to rename {0} to {1}", from, to));
        }
    }

    private void copyFrom(DirReader r) throws IOException {
        Attributes rec = r.findFirstRootDirectoryRecordInUse(false);
        while (null != rec) {
            this.copyChildsFrom(r, rec, this.out.addRootDirectoryRecord(new Attributes(rec)));
            rec = r.findNextDirectoryRecordInUse(rec, false);
        }
    }

    private void copyChildsFrom(DirReader r, Attributes src, Attributes dst) throws IOException {
        Attributes rec = r.findLowerDirectoryRecordInUse(src, false);
        while (null != rec) {
            this.copyChildsFrom(r, rec, this.out.addLowerDirectoryRecord(dst, new Attributes(rec)));
            rec = r.findNextDirectoryRecordInUse(rec, false);
        }
    }

    private File getFile() {
        return this.file;
    }

    private void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    private void setOriginalSequenceLength(boolean origSeqLength) {
        this.origSeqLength = origSeqLength;
    }

    private void setEncodingOptions(ImageEncodingOptions encOpts) {
        this.encOpts = encOpts;
    }

    private void setWidth(int width) {
        if (width < 40) {
            throw new IllegalArgumentException();
        }
        this.width = width;
    }

    private void setCheckDuplicate(boolean checkDuplicate) {
        this.checkDuplicate = checkDuplicate;
    }

    private void setRecordFactory(RecordFactory recFact) {
        this.recFact = recFact;
    }

    private void close() {
        IoKit.close((Closeable)this.in);
        this.in = null;
        this.out = null;
    }

    private void openForReadOnly(File file) throws IOException {
        this.file = file;
        this.in = new DirReader(file);
    }

    private void create(File file) throws IOException {
        this.file = file;
        DirWriter.createEmptyDirectory(file, UID.createUIDIfNull(this.fsInfo.getFilesetUID()), this.fsInfo.getFilesetID(), this.fsInfo.getDescriptorFile(), this.fsInfo.getDescriptorFileCharset());
        this.out = DirWriter.open(file);
        this.in = this.out;
        this.out.setEncodingOptions(this.encOpts);
        this.setCheckDuplicate(false);
    }

    private void open(File file) throws IOException {
        this.file = file;
        this.out = DirWriter.open(file);
        this.in = this.out;
        if (!this.origSeqLength) {
            this.out.setEncodingOptions(this.encOpts);
        }
        this.setCheckDuplicate(true);
    }

    private void list() throws IOException {
        this.checkIn();
        this.list("File Meta Information:", this.in.getFileMetaInformation());
        this.list("File-set Information:", this.in.getFileSetInformation());
        this.list(this.inUse ? this.in.findFirstRootDirectoryRecordInUse(false) : this.in.readFirstRootDirectoryRecord(), new StringBuilder());
    }

    private void list(String header, Attributes attrs) {
        Logger.info((String)header, (Object[])new Object[0]);
        Logger.info((String)attrs.toString(Integer.MAX_VALUE, this.width), (Object[])new Object[0]);
    }

    private void list(Attributes rec, StringBuilder index) throws IOException {
        int indexLen = index.length();
        int i = 1;
        while (null != rec) {
            index.append(i++).append('.');
            this.list(this.heading(rec, index), rec);
            this.list(this.inUse ? this.in.findLowerDirectoryRecordInUse(rec, false) : this.in.readLowerDirectoryRecord(rec), index);
            rec = this.inUse ? this.in.findNextDirectoryRecordInUse(rec, false) : this.in.readNextDirectoryRecord(rec);
            index.setLength(indexLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String heading(Attributes rec, StringBuilder index) {
        int prefixLen = index.length();
        try {
            String string = index.append(' ').append(rec.getString(267312, "")).append(':').toString();
            return string;
        }
        finally {
            index.setLength(prefixLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addReferenceTo(File f) throws IOException {
        String iuid;
        Attributes dataset;
        Attributes fmi;
        this.checkOut();
        this.checkRecordFactory();
        int n = 0;
        if (f.isDirectory()) {
            for (String s : f.list()) {
                n += this.addReferenceTo(new File(f, s));
            }
            return n;
        }
        if (f.equals(this.file)) {
            return 0;
        }
        ImageInputStream din = null;
        try {
            din = new ImageInputStream(f);
            din.setIncludeBulkData(ImageInputStream.IncludeBulkData.NO);
            fmi = din.readFileMetaInformation();
            dataset = din.readDataset(-1, 2145386512);
        }
        catch (IOException e) {
            Logger.info((String)MessageFormat.format("failed to parse {0}: {1}", f, e.getMessage()), (Object[])new Object[0]);
            int n2 = 0;
            return n2;
        }
        finally {
            if (null != din) {
                try {
                    din.close();
                }
                catch (Exception exception) {}
            }
        }
        char prompt = '.';
        if (null == fmi) {
            fmi = dataset.createFileMetaInformation("1.2.840.10008.1.2");
            prompt = 'F';
        }
        if (null == (iuid = fmi.getString(131075, null))) {
            Logger.info((String)MessageFormat.format("skip-file", f), (Object[])new Object[0]);
            return 0;
        }
        return this.addRecords(dataset, n, this.out.toFileIDs(f), prompt, iuid, fmi);
    }

    private int addRecords(Attributes dataset, int num, String[] fileIDs, char prompt, String iuid, Attributes fmi) throws IOException {
        String pid = dataset.getString(0x100020, null);
        String styuid = dataset.getString(0x20000D, null);
        String seruid = dataset.getString(0x20000E, null);
        if (null != styuid) {
            Attributes studyRec;
            Attributes patRec;
            if (null == pid) {
                pid = styuid;
                dataset.setString(0x100020, VR.LO, pid);
                prompt = (char)(prompt == 'F' ? 80 : 112);
            }
            if (null == (patRec = this.in.findPatientRecord(pid))) {
                patRec = this.recFact.createRecord(RecordType.PATIENT, null, dataset, null, null);
                this.out.addRootDirectoryRecord(patRec);
                ++num;
            }
            if (null == (studyRec = this.in.findStudyRecord(patRec, styuid))) {
                studyRec = this.recFact.createRecord(RecordType.STUDY, null, dataset, null, null);
                this.out.addLowerDirectoryRecord(patRec, studyRec);
                ++num;
            }
            if (null != seruid) {
                Attributes seriesRec = this.in.findSeriesRecord(studyRec, seruid);
                if (null == seriesRec) {
                    seriesRec = this.recFact.createRecord(RecordType.SERIES, null, dataset, null, null);
                    this.out.addLowerDirectoryRecord(studyRec, seriesRec);
                    ++num;
                }
                if (null != iuid) {
                    Attributes instRec;
                    if (this.checkDuplicate && null != (instRec = this.in.findLowerInstanceRecord(seriesRec, false, iuid))) {
                        return 0;
                    }
                    instRec = this.recFact.createRecord(dataset, fmi, fileIDs);
                    this.out.addLowerDirectoryRecord(seriesRec, instRec);
                    ++num;
                }
            }
        } else if (null != iuid) {
            if (this.checkDuplicate && null != this.in.findRootInstanceRecord(false, iuid)) {
                return 0;
            }
            Attributes instRec = this.recFact.createRecord(dataset, fmi, fileIDs);
            this.out.addRootDirectoryRecord(instRec);
            prompt = (char)(prompt == 'F' ? 82 : 114);
            ++num;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeReferenceTo(File f) throws IOException {
        Attributes instRec;
        String seruid;
        String styuid;
        String pid;
        String iuid;
        this.checkOut();
        int n = 0;
        if (f.isDirectory()) {
            for (String s : f.list()) {
                n += this.removeReferenceTo(new File(f, s));
            }
            return n;
        }
        ImageInputStream din = null;
        try {
            din = new ImageInputStream(f);
            din.setIncludeBulkData(ImageInputStream.IncludeBulkData.NO);
            Attributes fmi = din.readFileMetaInformation();
            Attributes dataset = din.readDataset(-1, 0x200010);
            String string = iuid = null != fmi ? fmi.getString(131075, null) : dataset.getString(524312, null);
            if (null == iuid) {
                Logger.info((String)MessageFormat.format("skip-file", f), (Object[])new Object[0]);
                int n2 = 0;
                return n2;
            }
            pid = dataset.getString(0x100020, null);
            styuid = dataset.getString(0x20000D, null);
            seruid = dataset.getString(0x20000E, null);
        }
        catch (IOException e) {
            Logger.info((String)MessageFormat.format("failed to parse {0}: {1}", f, e.getMessage()), (Object[])new Object[0]);
            int dataset = 0;
            return dataset;
        }
        finally {
            if (null != din) {
                try {
                    din.close();
                }
                catch (Exception exception) {}
            }
        }
        if (null != styuid && null != seruid) {
            Attributes patRec = this.in.findPatientRecord(null == pid ? styuid : pid);
            if (null == patRec) {
                return 0;
            }
            Attributes studyRec = this.in.findStudyRecord(patRec, styuid);
            if (null == studyRec) {
                return 0;
            }
            Attributes seriesRec = this.in.findSeriesRecord(studyRec, seruid);
            if (null == seriesRec) {
                return 0;
            }
            instRec = this.in.findLowerInstanceRecord(seriesRec, false, iuid);
        } else {
            instRec = this.in.findRootInstanceRecord(false, iuid);
        }
        if (null == instRec) {
            return 0;
        }
        this.out.deleteRecord(instRec);
        return 1;
    }

    public void commit() throws IOException {
        this.checkOut();
        this.out.commit();
    }

    private int purge() throws IOException {
        this.checkOut();
        return this.out.purge();
    }

    private void checkIn() {
        if (null == this.in) {
            throw new IllegalStateException("no open file");
        }
    }

    private void checkOut() {
        this.checkIn();
        if (null == this.out) {
            throw new IllegalStateException("file opened for read-only");
        }
    }

    private void checkRecordFactory() {
        if (null == this.recFact) {
            throw new IllegalStateException("no Record Factory initialized");
        }
    }

    private void loadCustomConfiguration() {
        try {
            this.recFact.loadConfiguration(Paths.get(this.recordConfig, new String[0]).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class FilesetInfo {
        private String uid;
        private String id;
        private File descFile;
        private String descFileCharset;

        public final String getFilesetUID() {
            return this.uid;
        }

        public final void setFilesetUID(String uid) {
            this.uid = uid;
        }

        public final String getFilesetID() {
            return this.id;
        }

        public final void setFilesetID(String id) {
            this.id = id;
        }

        public final File getDescriptorFile() {
            return this.descFile;
        }

        public final void setDescriptorFile(File descFile) {
            this.descFile = descFile;
        }

        public final String getDescriptorFileCharset() {
            return this.descFileCharset;
        }

        public final void setDescriptorFileCharset(String descFileCharset) {
            this.descFileCharset = descFileCharset;
        }
    }

    static class CSVParser {
        private final Pattern pattern;
        private final int[] tags;
        private final VR[] vrs;
        private final char quot;

        CSVParser(char delim, char quote, String header) {
            this.quot = quote;
            String regex = delim + "(?=(?:[^//" + this.quot + "]*//" + this.quot + "[^//" + this.quot + "]*//" + this.quot + ")*[^//" + this.quot + "]*$)";
            this.pattern = Pattern.compile(regex);
            String[] headers = this.parseFields(header);
            this.tags = new int[headers.length];
            this.vrs = new VR[headers.length];
            for (int i = 0; i < headers.length; ++i) {
                this.tags[i] = DICT.tagForKeyword(headers[i]);
                this.vrs[i] = DICT.vrOf(this.tags[i]);
            }
        }

        Attributes toDataset(String line) {
            Attributes dataset = new Attributes();
            String[] fields = this.parseFields(line);
            if (fields.length > this.tags.length) {
                Logger.warn((String)("Number of values in line " + line + " does not match number of headers. Hence line is ignored."), (Object[])new Object[0]);
                return null;
            }
            for (int i = 0; i < fields.length; ++i) {
                dataset.setString(this.tags[i], this.vrs[i], fields[i]);
            }
            return dataset;
        }

        private String[] parseFields(String line) {
            String[] fields = this.pattern.split(line, -1);
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = this.decode(fields[i]);
            }
            return fields;
        }

        private String decode(String field) {
            char[] doubleQuote = new char[]{this.quot, this.quot};
            return !field.isEmpty() && field.charAt(0) == this.quot && field.charAt(field.length() - 1) == this.quot ? field.substring(1, field.length() - 1).replace(String.valueOf(doubleQuote), String.valueOf(this.quot)) : field;
        }
    }
}

