/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2023 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.aoju.bus.image.nimble.codec;

import javax.imageio.spi.ImageReaderWriterSpi;
import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * @author Kimi Liu
 * @since Java 17+
 * @since Jul 2015
 */
final class FormatNameFilterIterator<T extends ImageReaderWriterSpi> implements Iterator<T> {
    private final Iterator<T> iter;
    private final String formatName;
    private T next = null;

    FormatNameFilterIterator(Iterator<T> iter, String formatName) {
        this.iter = iter;
        this.formatName = formatName;
        advance();
    }

    private static boolean contains(String[] names, String name) {
        for (int i = 0; i < names.length; i++) {
            if (name.equalsIgnoreCase(names[i])) {
                return true;
            }
        }

        return false;
    }

    private void advance() {
        while (iter.hasNext()) {
            T elt = iter.next();
            if (contains(elt.getFormatNames(), formatName)) {
                next = elt;
                return;
            }
        }

        next = null;
    }

    @Override
    public boolean hasNext() {
        return null != next;
    }

    @Override
    public T next() {
        if (null == next) {
            throw new NoSuchElementException();
        }
        T o = next;
        advance();
        return o;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}
