/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.image.Tag;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.Fragments;
import org.aoju.bus.image.galaxy.data.PersonName;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.SpecificCharacterSet;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.data.Value;
import org.aoju.bus.image.galaxy.io.ImageInputHandler;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXWriter
implements ImageInputHandler {
    private static final String NAMESPACE = "http://dicom.nema.org/PS3.19/models/NativeDICOM";
    private static final int BASE64_CHUNK_LENGTH = 768;
    private static final int BUFFER_LENGTH = 1024;
    private final ContentHandler ch;
    private final AttributesImpl atts = new AttributesImpl();
    private final char[] buffer = new char[1024];
    private boolean includeKeyword = true;
    private String namespace = "";

    public SAXWriter(ContentHandler ch) {
        this.ch = ch;
    }

    public static byte[] getBytes(char[] chars) {
        java.nio.charset.Charset cs = Charset.UTF_8;
        CharBuffer cb = CharBuffer.allocate(chars.length);
        cb.put(chars);
        cb.flip();
        ByteBuffer bb = cs.encode(cb);
        return bb.array();
    }

    public final boolean isIncludeKeyword() {
        return this.includeKeyword;
    }

    public final void setIncludeKeyword(boolean includeKeyword) {
        this.includeKeyword = includeKeyword;
    }

    public final boolean isIncludeNamespaceDeclaration() {
        return this.namespace == NAMESPACE;
    }

    public final void setIncludeNamespaceDeclaration(boolean includeNameSpaceDeclaration) {
        this.namespace = includeNameSpaceDeclaration ? NAMESPACE : "";
    }

    public void write(Attributes attrs) throws SAXException {
        this.startDocument();
        this.writeItem(attrs);
        this.endDocument();
    }

    private void writeItem(final Attributes item) throws SAXException {
        final SpecificCharacterSet cs = item.getSpecificCharacterSet();
        try {
            item.accept(new Attributes.Visitor(){
                final /* synthetic */ SAXWriter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean visit(Attributes attrs, int tag, VR vr, Object value) throws Exception {
                    this.this$0.writeAttribute(tag, vr, value, cs, item);
                    return true;
                }
            }, false);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startDataset(ImageInputStream dis) throws IOException {
        try {
            this.startDocument();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void endDataset(ImageInputStream dis) throws IOException {
        try {
            this.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    private void startDocument() throws SAXException {
        this.ch.startDocument();
        this.startElement("NativeDicomModel", "xml:space", "preserve");
    }

    private void endDocument() throws SAXException {
        this.endElement("NativeDicomModel");
        this.ch.endDocument();
    }

    private void startElement(String name, String attrName, int attrValue) throws SAXException {
        this.startElement(name, attrName, Integer.toString(attrValue));
    }

    private void startElement(String name, String attrName, String attrValue) throws SAXException {
        this.addAttribute(attrName, attrValue);
        this.startElement(name);
    }

    private void startElement(String name) throws SAXException {
        this.ch.startElement(this.namespace, name, name, this.atts);
        this.atts.clear();
    }

    private void endElement(String name) throws SAXException {
        this.ch.endElement(this.namespace, name, name);
    }

    private void addAttribute(String name, String value) {
        this.atts.addAttribute(this.namespace, name, name, "NMTOKEN", value);
    }

    private void writeAttribute(int tag, VR vr, Object value, SpecificCharacterSet cs, Attributes attrs) throws SAXException {
        if (Tag.isGroupLength(tag) || Tag.isPrivateCreator(tag)) {
            return;
        }
        String privateCreator = attrs.getPrivateCreator(tag);
        this.addAttributes(tag, vr, privateCreator);
        this.startElement("DicomAttribute");
        if (value instanceof Value) {
            this.writeAttribute((Value)value, attrs.bigEndian());
        } else if (!vr.isInlineBinary()) {
            this.writeValues(vr, value, attrs.bigEndian(), attrs.getSpecificCharacterSet(vr));
        } else if (value instanceof byte[]) {
            this.writeInlineBinary(attrs.bigEndian() ? vr.toggleEndian((byte[])value, true) : (byte[])value);
        } else {
            throw new IllegalArgumentException("vr: " + String.valueOf((Object)vr) + ", value class: " + String.valueOf(value.getClass()));
        }
        this.endElement("DicomAttribute");
    }

    private void writeAttribute(Value value, boolean bigEndian) throws SAXException {
        if (value.isEmpty()) {
            return;
        }
        if (value instanceof Sequence) {
            Sequence seq = (Sequence)value;
            int number = 0;
            for (Attributes item : seq) {
                this.startElement("Item", "number", ++number);
                this.writeItem(item);
                this.endElement("Item");
            }
        } else if (value instanceof Fragments) {
            Fragments frags = (Fragments)value;
            int number = 0;
            for (Object frag : frags) {
                ++number;
                if (frag instanceof Value && ((Value)frag).isEmpty()) continue;
                this.startElement("DataFragment", "number", number);
                if (frag instanceof BulkData) {
                    this.writeBulkData((BulkData)frag);
                } else {
                    byte[] b = (byte[])frag;
                    if (bigEndian) {
                        frags.vr().toggleEndian(b, true);
                    }
                    this.writeInlineBinary(b);
                }
                this.endElement("DataFragment");
            }
        } else if (value instanceof BulkData) {
            this.writeBulkData((BulkData)value);
        }
    }

    @Override
    public void readValue(ImageInputStream dis, Attributes attrs) throws IOException {
        int tag = dis.tag();
        VR vr = dis.vr();
        int len = dis.length();
        if (Tag.isGroupLength(tag) || Tag.isPrivateCreator(tag)) {
            dis.readValue(dis, attrs);
        } else if (dis.isExcludeBulkData()) {
            if (len == -1) {
                dis.readValue(dis, attrs);
            } else {
                dis.skipFully(len);
            }
        } else {
            try {
                String privateCreator = attrs.getPrivateCreator(tag);
                this.addAttributes(tag, vr, privateCreator);
                this.startElement("DicomAttribute");
                if (vr == VR.SQ || len == -1) {
                    dis.readValue(dis, attrs);
                } else if (len > 0) {
                    if (dis.isIncludeBulkDataURI()) {
                        this.writeBulkData(dis.createBulkData(dis));
                    } else {
                        byte[] b = dis.readValue();
                        if (tag == 131088 || tag == 524293) {
                            attrs.setBytes(tag, vr, b);
                        }
                        if (vr.isInlineBinary()) {
                            this.writeInlineBinary(dis.bigEndian() ? vr.toggleEndian(b, false) : b);
                        } else {
                            this.writeValues(vr, b, dis.bigEndian(), attrs.getSpecificCharacterSet(vr));
                        }
                    }
                }
                this.endElement("DicomAttribute");
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
        }
    }

    private void addAttributes(int tag, VR vr, String privateCreator) {
        String keyword;
        if (null != privateCreator) {
            tag &= 0xFFFF00FF;
        }
        if (this.includeKeyword && null != (keyword = ElementDictionary.keywordOf(tag, privateCreator)) && !keyword.isEmpty()) {
            this.addAttribute("keyword", keyword);
        }
        this.addAttribute("tag", Tag.toHexString(tag));
        if (null != privateCreator) {
            this.addAttribute("privateCreator", privateCreator);
        }
        this.addAttribute("vr", vr.name());
    }

    @Override
    public void readValue(ImageInputStream dis, Sequence seq) throws IOException {
        try {
            this.startElement("Item", "number", seq.size() + 1);
            dis.readValue(dis, seq);
            this.endElement("Item");
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    private void writeValues(VR vr, Object val, boolean bigEndian, SpecificCharacterSet cs) throws SAXException {
        if (vr.isStringType()) {
            val = vr.toStrings(val, bigEndian, cs);
        }
        int vm = vr.vmOf(val);
        for (int i = 0; i < vm; ++i) {
            String s = vr.toString(val, bigEndian, i, null);
            this.addAttribute("number", Integer.toString(i + 1));
            if (vr == VR.PN) {
                PersonName pn = new PersonName(s, true);
                this.startElement("PersonName");
                this.writePNGroup("Alphabetic", pn, PersonName.Group.Alphabetic);
                this.writePNGroup("Ideographic", pn, PersonName.Group.Ideographic);
                this.writePNGroup("Phonetic", pn, PersonName.Group.Phonetic);
                this.endElement("PersonName");
                continue;
            }
            this.writeElement("Value", s);
        }
    }

    @Override
    public void readValue(ImageInputStream dis, Fragments frags) throws IOException {
        int len = dis.length();
        if (dis.isExcludeBulkData()) {
            dis.skipFully(len);
        } else {
            try {
                frags.add(new byte[0]);
                if (len > 0) {
                    this.startElement("DataFragment", "number", frags.size());
                    if (dis.isIncludeBulkDataURI()) {
                        this.writeBulkData(dis.createBulkData(dis));
                    } else {
                        byte[] b = dis.readValue();
                        if (dis.bigEndian()) {
                            frags.vr().toggleEndian(b, false);
                        }
                        this.writeInlineBinary(b);
                    }
                    this.endElement("DataFragment");
                }
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
        }
    }

    private void writeInlineBinary(byte[] b) throws SAXException {
        int len;
        this.startElement("InlineBinary");
        char[] buf = this.buffer;
        for (int off = 0; off < b.length; off += len) {
            len = Math.min(b.length - off, 768);
            Base64.encode((byte[])b, (int)off, (int)len, (char[])buf, (int)0);
            this.ch.characters(buf, 0, len * 4 / 3 + 3 & 0xFFFFFFFC);
        }
        this.endElement("InlineBinary");
    }

    private void writeBulkData(BulkData bulkData) throws SAXException {
        if (null != bulkData.getUUID()) {
            this.addAttribute("uuid", bulkData.getUUID());
        }
        if (null != bulkData.getURI()) {
            this.addAttribute("uri", bulkData.getURI());
        }
        this.startElement("BulkData");
        this.endElement("BulkData");
    }

    private void writeElement(String qname, String s) throws SAXException {
        if (null != s) {
            this.startElement(qname);
            char[] buf = this.buffer;
            int off = 0;
            int totlen = s.length();
            while (off < totlen) {
                int len = Math.min(totlen - off, buf.length);
                s.getChars(off, off += len, buf, 0);
                this.ch.characters(buf, 0, len);
            }
            this.endElement(qname);
        }
    }

    private void writePNGroup(String qname, PersonName pn, PersonName.Group group) throws SAXException {
        if (pn.contains(group)) {
            this.startElement(qname);
            this.writeElement("FamilyName", pn.get(group, PersonName.Component.FamilyName));
            this.writeElement("GivenName", pn.get(group, PersonName.Component.GivenName));
            this.writeElement("MiddleName", pn.get(group, PersonName.Component.MiddleName));
            this.writeElement("NamePrefix", pn.get(group, PersonName.Component.NamePrefix));
            this.writeElement("NameSuffix", pn.get(group, PersonName.Component.NameSuffix));
            this.endElement(qname);
        }
    }
}

