/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.media;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.media.AbstractStowrs;
import org.aoju.bus.image.metric.Progress;
import org.aoju.bus.logger.Logger;

public class StowrsMultiFiles
extends AbstractStowrs {
    public StowrsMultiFiles(String requestURL, String contentType) {
        this(requestURL, contentType, null, null);
    }

    public StowrsMultiFiles(String requestURL, String contentType, String agentName, Map<String, String> headers) {
        super(requestURL, contentType, agentName, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status uploadDicom(List<String> filesOrFolders, boolean recursive) throws IOException {
        String message;
        HttpURLConnection httpPost = this.buildConnection();
        Status state = new Status(new Progress());
        int nbFile = 0;
        try (DataOutputStream out = new DataOutputStream(httpPost.getOutputStream());){
            for (String entry : filesOrFolders) {
                File file = new File(entry);
                if (file.isDirectory()) {
                    ArrayList<File> fileList = new ArrayList<File>();
                    Builder.getAllFilesInDirectory(file, fileList, recursive);
                    for (File f : fileList) {
                        this.uploadFile(f, out);
                        ++nbFile;
                    }
                    continue;
                }
                this.uploadFile(file, out);
                ++nbFile;
            }
            Attributes error = this.writeEndMarkers(httpPost, out);
            if (null == error) {
                state.setStatus(0);
                message = "all the files has been tranfered";
            } else {
                Sequence seq;
                message = "one or more files has not been tranfered";
                state.setStatus(45056);
                Progress p = state.getProgress();
                if (null != p && null != (seq = error.getSequence(528792)) && !seq.isEmpty()) {
                    Attributes cmd = Optional.ofNullable(p.getAttributes()).orElseGet(Attributes::new);
                    cmd.setInt(2304, VR.US, 45056);
                    cmd.setInt(4129, VR.US, nbFile);
                    cmd.setInt(4130, VR.US, seq.size());
                    cmd.setInt(4131, VR.US, 0);
                    cmd.setInt(4128, VR.US, 0);
                    p.setAttributes(cmd);
                    message = seq.stream().map(s -> s.getString(528725, "Unknown SopUID") + " -> " + s.getString(528791)).collect(Collectors.joining(","));
                    Status status = Status.build(state, null, new RuntimeException("Failed instances: " + message));
                    return status;
                }
            }
        }
        catch (Exception e) {
            state.setStatus(49152);
            Logger.error((String)"STOWRS: error when posting data", (Object[])new Object[]{e});
            Status status = Status.build(state, "STOWRS: error when posting data", e);
            return status;
        }
        finally {
            this.removeConnection(httpPost);
        }
        return Status.build(state, message, null);
    }

    private void uploadFile(File file, DataOutputStream out) throws IOException {
        this.writeContentMarkers(out);
        Files.copy(file.toPath(), out);
    }
}

