/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.aoju.bus.core.toolkit.ByteKit;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.Fragments;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;
import org.aoju.bus.logger.Logger;

public class SegmentedImageStream
extends ImageInputStreamImpl {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final ImageInputStream stream;
    private final List<Object> fragments;
    private int curSegment = 0;
    private int firstSegment = 1;
    private int lastSegment = Integer.MAX_VALUE;
    private long curSegmentEnd = -1L;
    private byte[] byteFrag;
    private ImageDescriptor imageDescriptor;

    public SegmentedImageStream(ImageInputStream stream, Fragments pixeldataFragments, int frameIndex) throws IOException {
        if (frameIndex == -1) {
            frameIndex = 0;
        } else {
            this.firstSegment = frameIndex + 1;
            this.lastSegment = frameIndex + 2;
        }
        this.fragments = pixeldataFragments;
        this.stream = stream;
        this.curSegment = frameIndex;
        this.seek(0L);
    }

    public SegmentedImageStream(ImageInputStream iis, long streamPosition, int length, boolean singleFrame) throws IOException {
        this.fragments = new Fragments(VR.OB, false, 16);
        if (!singleFrame) {
            this.lastSegment = 2;
        }
        this.fragments.add(new byte[0]);
        this.fragments.add(new BulkData("pixelData://", streamPosition, length, false));
        this.stream = iis;
        this.seek(0L);
    }

    public SegmentedImageStream(byte[] data) throws IOException {
        this.stream = null;
        this.fragments = new Fragments(VR.OB, false, 2);
        this.fragments.add(new byte[0]);
        this.fragments.add(data);
        this.lastSegment = 2;
        this.seek(0L);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(long pos) throws IOException {
        super.seek(pos);
        long beforePos = 0L;
        for (int i = this.firstSegment; i < this.lastSegment; ++i) {
            BulkData bulk = null;
            long bulkOffset = -1L;
            int bulkLength = -1;
            List<Object> list = this.fragments;
            synchronized (list) {
                if (i < this.fragments.size()) {
                    Object fragment = this.fragments.get(i);
                    if (fragment instanceof BulkData) {
                        bulk = (BulkData)this.fragments.get(i);
                        bulkOffset = bulk.offset();
                        bulkLength = bulk.length();
                    } else {
                        this.byteFrag = (byte[])fragment;
                        bulkLength = this.byteFrag.length;
                        bulkOffset = beforePos;
                    }
                }
            }
            if (bulkOffset == -1L || bulkLength == -1) {
                bulk = this.updateBulkData(i);
                if (null == bulk) {
                    this.lastSegment = i;
                    this.curSegment = -1;
                    super.seek(beforePos);
                    return;
                }
                bulkOffset = bulk.offset();
                bulkLength = bulk.length();
            }
            if (i >= this.lastSegment) {
                this.curSegment = -1;
                super.seek(beforePos);
                return;
            }
            long deltaInEnd = pos - beforePos;
            if (pos >= (beforePos += (long)bulkLength & 0xFFFFFFFFL)) continue;
            this.curSegment = i;
            this.curSegmentEnd = beforePos;
            if (null != bulk) {
                this.stream.seek(bulk.offset() + deltaInEnd);
            }
            return;
        }
        this.curSegment = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BulkData updateBulkData(int endBulk) throws IOException {
        BulkData last = null;
        for (int i = 1; i <= endBulk; ++i) {
            BulkData bulk = null;
            long bulkOffset = -1L;
            int bulkLength = -1;
            List<Object> list = this.fragments;
            synchronized (list) {
                if (i < this.fragments.size()) {
                    bulk = (BulkData)this.fragments.get(i);
                    bulkOffset = bulk.offset();
                    bulkLength = bulk.length();
                }
            }
            if (bulkOffset == -1L) {
                long testOffset = last.offset() + (0xFFFFFFFFL & (long)last.length());
                bulk = this.readBulkAt(testOffset, i);
            } else if (bulkLength == -1) {
                bulk = this.readBulkAt(bulkOffset - 8L, i);
            }
            if (null == bulk) {
                return null;
            }
            last = bulk;
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BulkData readBulkAt(long testOffset, int at) throws IOException {
        BulkData bulk;
        byte[] data = new byte[8];
        this.stream.seek(testOffset);
        int size = this.stream.read(data);
        if (size < 8) {
            return null;
        }
        int tag = ByteKit.bytesToTagLE((byte[])data, (int)0);
        if (tag == -73507) {
            this.lastSegment = this.fragments.size();
            return null;
        }
        if (tag != -73728) {
            throw new IOException("At " + testOffset + " isn't an Item(" + Integer.toHexString(-73728) + "), but is " + Integer.toHexString(tag));
        }
        int itemLen = ByteKit.bytesToIntLE((byte[])data, (int)4);
        List<Object> list = this.fragments;
        synchronized (list) {
            if (at < this.fragments.size()) {
                bulk = (BulkData)this.fragments.get(at);
                bulk.setOffset(testOffset + 8L);
                bulk.setLength(itemLen);
            } else {
                bulk = new BulkData("compressedPixelData://", testOffset + 8L, itemLen, false);
                this.fragments.add(bulk);
            }
        }
        return bulk;
    }

    @Override
    public int read() throws IOException {
        if (!this.prepareRead()) {
            return -1;
        }
        this.bitOffset = 0;
        int val = this.stream.read();
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    private boolean prepareRead() throws IOException {
        if (this.curSegment < 0) {
            return false;
        }
        if (this.streamPos < this.curSegmentEnd) {
            return true;
        }
        this.seek(this.streamPos);
        return this.curSegment >= 0 && this.curSegment < this.lastSegment;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nbytes;
        if (!this.prepareRead()) {
            return -1;
        }
        this.bitOffset = 0;
        int bytesToRead = Math.min(len, (int)(this.curSegmentEnd - this.streamPos));
        if (null != this.byteFrag) {
            System.arraycopy(this.byteFrag, (int)(this.streamPos - this.curSegmentEnd + (long)this.byteFrag.length), b, off, bytesToRead);
            nbytes = bytesToRead;
        } else {
            nbytes = this.stream.read(b, off, bytesToRead);
        }
        if (nbytes != -1) {
            this.streamPos += (long)nbytes;
        }
        return nbytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastSegmentEnd() {
        List<Object> list = this.fragments;
        synchronized (list) {
            BulkData bulk = (BulkData)this.fragments.get(this.fragments.size() - 1);
            return bulk.getSegmentEnd();
        }
    }

    public long getOffsetPostPixelData() throws IOException {
        long ret = this.getLastSegmentEnd();
        if (ret != -1L) {
            return ret + 8L;
        }
        this.updateBulkData(this.fragments.size() + 1025);
        ret = this.getLastSegmentEnd();
        return ret + 8L;
    }

    public long transferTo(OutputStream out) throws IOException {
        int read;
        Objects.requireNonNull(out, "out");
        long transferred = 0L;
        byte[] buffer = new byte[8192];
        while ((read = this.read(buffer, 0, 8192)) > 0) {
            out.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }

    @Override
    public long length() {
        try {
            long wasPos = this.getStreamPosition();
            this.seek(Long.MAX_VALUE);
            long ret = this.getStreamPosition();
            this.seek(wasPos);
            Logger.debug((String)"wasPos {} end {}", (Object[])new Object[]{wasPos, ret});
            return ret;
        }
        catch (IOException e) {
            Logger.warn((String)"Caught error determining length:{}", (Object[])new Object[]{e});
            Logger.debug((String)"Stack trace", (Object[])new Object[]{e});
            return -1L;
        }
    }
}

