/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.support.rate.jdk;

public class RateLimiterObject {
    private double rate;
    private long capacity;
    private long lastSyncTime;
    private double storedPermits;

    public synchronized boolean tryAcquire(long permits, double rate, long capacity) {
        if (permits > capacity) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (rate != this.rate || capacity != this.capacity) {
            this.rate = rate;
            this.capacity = capacity;
            this.storedPermits = capacity - permits;
            this.lastSyncTime = now;
            return true;
        }
        this.resync(now);
        if (this.storedPermits >= (double)permits) {
            this.storedPermits -= (double)permits;
            return true;
        }
        return false;
    }

    private void resync(long nowMicros) {
        double newPermits = (double)(nowMicros - this.lastSyncTime) * this.rate / 1000.0 + this.storedPermits;
        this.storedPermits = Math.max(newPermits, (double)this.capacity);
        this.lastSyncTime = nowMicros;
    }
}

