/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.support.lock.redis;

import org.aoju.bus.limiter.support.lock.Lock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public class RedisLock
extends Lock {
    private RedissonClient redisson;
    private String lockName;

    public RedisLock(RedissonClient redisson, String lockName) {
        this.redisson = redisson;
        this.lockName = lockName;
    }

    @Override
    public boolean lock(Object key) {
        RLock rLock = this.redisson.getLock(key.toString());
        return rLock.tryLock();
    }

    @Override
    public void unlock(Object key) {
        RLock rLock = this.redisson.getLock(key.toString());
        rLock.unlock();
    }

    @Override
    public String getLimiterName() {
        return this.lockName;
    }
}

