/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.metadata;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.limiter.Handler;
import org.aoju.bus.limiter.Injector;
import org.aoju.bus.limiter.Limiter;
import org.aoju.bus.limiter.Resolver;
import org.aoju.bus.limiter.annotation.LimiterParameter;
import org.aoju.bus.limiter.metadata.LimitedResourceMetadata;
import org.aoju.bus.limiter.resource.LimitedResource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;

public abstract class AbstractLimitedResourceMetadata<T extends LimitedResource>
implements LimitedResourceMetadata<T>,
Observer {
    private final BeanFactory beanFactory;
    private final T limitedResource;
    private Limiter limiter;
    private Handler errorHandler;
    private Resolver limitedFallbackResolver;
    private Collection<Injector> argumentInjectors;
    private Map<String, Object> limiterParameters;
    private Class<?> targetClass;
    private Method targetMethod;

    public AbstractLimitedResourceMetadata(T limitedResource, Class<?> targetClass, Method targetMethod, BeanFactory beanFactory) {
        this.limitedResource = limitedResource;
        this.beanFactory = beanFactory;
        this.targetClass = targetClass;
        this.targetMethod = targetMethod;
        this.parse(limitedResource);
    }

    protected abstract void parseInternal(T var1);

    private void parse(T limitedResource) {
        this.limiter = (Limiter)this.beanFactory.getBean(limitedResource.getLimiter());
        this.errorHandler = (Handler)this.beanFactory.getBean(limitedResource.getErrorHandler());
        try {
            Method fallbackMethod = this.targetClass.getDeclaredMethod(limitedResource.getFallback(), this.targetMethod.getParameterTypes());
            fallbackMethod.setAccessible(true);
            this.limitedFallbackResolver = (method, clazz, args, limitedResource1, target) -> {
                try {
                    return fallbackMethod.invoke(target, args);
                }
                catch (IllegalAccessException e) {
                    return null;
                }
                catch (InvocationTargetException e) {
                    return null;
                }
            };
        }
        catch (NoSuchMethodException e) {
            this.limitedFallbackResolver = (Resolver)this.beanFactory.getBean(limitedResource.getFallback());
        }
        if (!CollUtils.isEmpty(limitedResource.getArgumentInjectors())) {
            this.argumentInjectors = new ArrayList<Injector>();
            Collection<String> injectors = limitedResource.getArgumentInjectors();
            for (String si : injectors) {
                this.argumentInjectors.add((Injector)this.beanFactory.getBean(si));
            }
        }
        this.limiterParameters = this.findLimiterParameters();
        this.parseInternal(limitedResource);
        if (limitedResource instanceof Observable) {
            ((Observable)limitedResource).addObserver(this);
        }
    }

    private Map<String, Object> findLimiterParameters() {
        Field[] fields = this.getLimitedResource().getClass().getDeclaredFields();
        HashMap<String, Object> retVal = null;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            field.setAccessible(true);
            if (!AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, LimiterParameter.class)) continue;
            if (retVal == null) {
                retVal = new HashMap<String, Object>();
            }
            try {
                retVal.put(field.getName(), field.get(this.getLimitedResource()));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return retVal;
    }

    @Override
    public Map<String, Object> getLimiterParameters() {
        return this.limiterParameters;
    }

    @Override
    public T getLimitedResource() {
        return this.limitedResource;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.parse(this.limitedResource);
    }

    @Override
    public Limiter getLimiter() {
        return this.limiter;
    }

    @Override
    public Resolver getFallback() {
        return this.limitedFallbackResolver;
    }

    @Override
    public Handler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public Collection<Injector> getArgumentInjectors() {
        return this.argumentInjectors;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public Method getTargetMethod() {
        return this.targetMethod;
    }
}

