/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.support.peak.jdk;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import org.aoju.bus.limiter.support.peak.PeakLimiter;

public class JdkPeakLimiter
extends PeakLimiter {
    private String limiterName;
    private LoadingCache<CacheKey, Semaphore> cache;

    public JdkPeakLimiter(String limiterName) {
        this.limiterName = limiterName;
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(16).initialCapacity(2048).build((CacheLoader)new CacheLoader<CacheKey, Semaphore>(){

            public Semaphore load(CacheKey key) {
                return new Semaphore(key.max);
            }
        });
    }

    @Override
    public boolean acquire(Object key, int max) {
        CacheKey cacheKey = new CacheKey(key, max);
        return ((Semaphore)this.cache.getIfPresent((Object)cacheKey)).tryAcquire();
    }

    @Override
    public void release(Object key, int max) {
        CacheKey cacheKey = new CacheKey(key, max);
        Semaphore semaphore = (Semaphore)this.cache.getIfPresent((Object)cacheKey);
        if (semaphore != null) {
            semaphore.release();
        }
    }

    @Override
    public String getLimiterName() {
        return this.limiterName;
    }

    public static class CacheKey {
        private Object key;
        private int max;

        public CacheKey(Object key, int max) {
            this.key = key;
            this.max = max;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.max == cacheKey.max && Objects.equals(this.key, cacheKey.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.max);
        }
    }
}

