/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.support.rate.jdk;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.limiter.support.rate.RateLimiter;
import org.aoju.bus.limiter.support.rate.jdk.RateLimiterObject;

public class JdkRateLimiter
extends RateLimiter {
    private String rateLimiterName;
    private LoadingCache<CacheKey, RateLimiterObject> cache;

    public JdkRateLimiter(String rateLimiterName, long expireAfterAccess, TimeUnit expireAfterAccessUnit) {
        this.rateLimiterName = rateLimiterName;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(expireAfterAccess, expireAfterAccessUnit).concurrencyLevel(16).build((CacheLoader)new CacheLoader<CacheKey, RateLimiterObject>(){

            public RateLimiterObject load(CacheKey key) {
                return new RateLimiterObject();
            }
        });
    }

    @Override
    public boolean acquire(Object key, double rate, long capacity) {
        CacheKey cacheKey = new CacheKey(key, rate, capacity);
        RateLimiterObject rateLimiterObject = (RateLimiterObject)this.cache.getUnchecked((Object)cacheKey);
        return rateLimiterObject.tryAcquire(1L, rate, capacity);
    }

    @Override
    public String getLimiterName() {
        return this.rateLimiterName;
    }

    private static class CacheKey {
        private Object key;
        private double rate;
        private long capacity;

        public CacheKey(Object key, double rate, long capacity) {
            this.key = key;
            this.rate = rate;
            this.capacity = capacity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Double.compare(cacheKey.rate, this.rate) == 0 && this.capacity == cacheKey.capacity && Objects.equals(this.key, cacheKey.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.rate, this.capacity);
        }
    }
}

