/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.resource;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.limiter.Parser;
import org.aoju.bus.limiter.resource.LimitedResource;
import org.aoju.bus.limiter.resource.LimitedResourceSource;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.AnnotationMetadataReadingVisitor;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

public class LimitedResourceScanner
implements LimitedResourceSource {
    static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    Map<String, LimitedResource> limitedResourceMap = new HashMap<String, LimitedResource>();
    Map<String, Collection<LimitedResource>> limitedResourceRegistry = new HashMap<String, Collection<LimitedResource>>();
    private String resourcePattern = "**/*.class";
    private ResourcePatternResolver resourcePatternResolver;
    private MetadataReaderFactory metadataReaderFactory;
    private String basePackage;
    private Collection<Parser> limiterAnnotationParsers;

    public LimitedResourceScanner(String basePackage, Collection<Parser> limiterAnnotationParsers, ResourceLoader resourceLoader) {
        this.basePackage = basePackage;
        this.limiterAnnotationParsers = limiterAnnotationParsers;
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public void scanLimitedResource() {
        try {
            Resource[] resources;
            String packageSearchPath = "classpath*:" + ClassKit.convertClassNameToResourcePath((String)this.basePackage) + "/" + this.resourcePattern;
            for (Resource resource : resources = this.resourcePatternResolver.getResources(packageSearchPath)) {
                MetadataReader metadataReader;
                AnnotationMetadataReadingVisitor classVisitor;
                if (!resource.isReadable() || (classVisitor = (AnnotationMetadataReadingVisitor)(metadataReader = this.metadataReaderFactory.getMetadataReader(resource)).getClassMetadata()).isInterface() || classVisitor.isAbstract()) continue;
                for (Parser parser : this.limiterAnnotationParsers) {
                    Set methodMetadata = classVisitor.getAnnotatedMethods(parser.getSupportAnnotation().getName());
                    if (CollKit.isEmpty((Collection)methodMetadata)) continue;
                    for (MethodMetadata metadata : methodMetadata) {
                        Collection<Object> tempList;
                        LimitedResource limitedResource;
                        AnnotationAttributes attributes = (AnnotationAttributes)metadata.getAnnotationAttributes(parser.getSupportAnnotation().getName());
                        if (null == attributes || null == (limitedResource = parser.parseLimiterAnnotation(attributes))) continue;
                        String key = metadata.getDeclaringClassName() + "#" + metadata.getMethodName() + "@" + parser.getSupportAnnotation().getSimpleName();
                        this.limitedResourceMap.put(key, limitedResource);
                        String classMethod = metadata.getDeclaringClassName() + "#" + metadata.getMethodName();
                        if (!this.limitedResourceRegistry.containsKey(classMethod)) {
                            tempList = new ArrayList();
                            tempList.add(limitedResource);
                            this.limitedResourceRegistry.put(classMethod, tempList);
                            continue;
                        }
                        tempList = this.limitedResourceRegistry.get(classMethod);
                        tempList.add(limitedResource);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public Collection<LimitedResource> getLimitedResource(Class<?> targetClass, Method method) {
        String key = targetClass.getName() + "#" + method.getName();
        return this.limitedResourceRegistry.get(key);
    }
}

