/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.aliyun;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.notify.magic.Response;
import org.aoju.bus.notify.metric.Properties;
import org.aoju.bus.notify.metric.Template;
import org.aoju.bus.notify.provider.AbstractProvider;

public class AbstractAliyunProvider<T extends Template, K extends Properties>
extends AbstractProvider<T, K> {
    private static final String SUCCESS_RESULT = "OK";

    public AbstractAliyunProvider(K properties) {
        super(properties);
    }

    protected String specialUrlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw new InstrumentException("aliyun specialUrlEncode error");
        }
    }

    protected String getSign(Map<String, String> params) {
        TreeMap<String, String> sortParas = new TreeMap<String, String>(params);
        Iterator<String> it = sortParas.keySet().iterator();
        StringBuilder sortQueryStringTmp = new StringBuilder();
        while (it.hasNext()) {
            String key = it.next();
            sortQueryStringTmp.append("&").append(this.specialUrlEncode(key)).append("=").append(this.specialUrlEncode(params.get(key)));
        }
        String sortedQueryString = sortQueryStringTmp.substring(1);
        String stringToSign = "GET&" + this.specialUrlEncode("/") + "&" + this.specialUrlEncode(sortedQueryString);
        return this.sign(stringToSign);
    }

    protected String sign(String stringToSign) {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec((this.properties.getAppSecret() + "&").getBytes(StandardCharsets.UTF_8), "HmacSHA1"));
            byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(signData);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new InstrumentException("aliyun specialUrlEncode error");
        }
    }

    protected Response checkResponse(String response) {
        JSONObject object = JSON.parseObject((String)response);
        return ((Response.ResponseBuilder)((Response.ResponseBuilder)Response.builder().result(SUCCESS_RESULT.equals(object.getString("Code")))).desc(object.getString("Code"))).build();
    }
}

