/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.netease;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.netease.NeteaseTemplate;

public abstract class NeteaseProvider
extends AbstractProvider<NeteaseTemplate, Context> {
    private static final String SUCCESS_RESULT = "200";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public NeteaseProvider(Context properties) {
        super(properties);
    }

    private static String encode(String value) {
        if (value == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("sha1");
            messageDigest.update(value.getBytes());
            return NeteaseProvider.getFormattedText(messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (byte aByte : bytes) {
            buf.append(HEX_DIGITS[aByte >> 4 & 0xF]);
            buf.append(HEX_DIGITS[aByte & 0xF]);
        }
        return buf.toString();
    }

    protected HashMap<String, String> getPostHeader() {
        String curTime = String.valueOf(new Date().getTime() / 1000L);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("AppKey", this.properties.getAppKey());
        map.put("Nonce", this.properties.getAppNonce());
        map.put("CurTime", curTime);
        map.put("CheckSum", this.getCheckSum(curTime));
        return map;
    }

    public Message post(String routerUrl, Map<String, Object> map) {
        HashMap<String, String> header = this.getPostHeader();
        Logger.debug((String)"netease send\uff1a{}", (Object[])new Object[]{map});
        String response = Httpx.post((String)routerUrl, map, header);
        Logger.debug((String)"netease result\uff1a{}", (Object[])new Object[]{response});
        JSONObject object = JSON.parseObject((String)response);
        return Message.builder().errcode(SUCCESS_RESULT.equals(object.getString("code")) ? Builder.ErrorCode.SUCCESS.getCode() : object.getString("code")).errmsg(object.getString("desc")).build();
    }

    private String getCheckSum(String curTime) {
        return NeteaseProvider.encode(this.properties.getAppSecret() + this.properties.getAppNonce() + curTime);
    }
}

