/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.aliyun;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.UUID;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.aliyun.AliyunProvider;
import org.aoju.bus.notify.provider.aliyun.AliyunSmsTemplate;

public class AliyunSmsProvider
extends AliyunProvider<AliyunSmsTemplate, Context> {
    private static final String ALIYUN_PRODUCT_DOMAIN = "dysmsapi.aliyuncs.com";

    public AliyunSmsProvider(Context properties) {
        super(properties);
    }

    @Override
    public Message send(AliyunSmsTemplate template) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("SignatureMethod", "HMAC-SHA1");
        paras.put("SignatureNonce", UUID.randomUUID().toString());
        paras.put("AccessKeyId", this.properties.getAppKey());
        paras.put("SignatureVersion", "1.0");
        paras.put("Timestamp", df.format(new Date()));
        paras.put("Format", "JSON");
        paras.put("Action", "SendSms");
        paras.put("Version", "2017-05-25");
        paras.put("RegionId", "cn-hangzhou");
        paras.put("PhoneNumbers", template.getReceive());
        paras.put("SignName", this.properties.getSignName());
        paras.put("TemplateParam", template.getTemplateParam());
        paras.put("TemplateCode", template.getTempCode());
        paras.put("Signature", this.getSign(paras));
        HashMap<String, String> map = new HashMap<String, String>();
        for (String str : paras.keySet()) {
            map.put(this.specialUrlEncode(str), this.specialUrlEncode((String)paras.get(str)));
        }
        return this.checkResponse(Httpx.get((String)"https://dysmsapi.aliyuncs.com", map));
    }
}

