/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.dingtalk;

import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.dingtalk.DingTalkProperty;

public class DingTalkProvider
extends AbstractProvider<DingTalkProperty, Context> {
    private static final String SUCCESS_RESULT = "200";
    private static final String DINGTALK_TOKEN_API = "https://oapi.dingtalk.com/gettoken";
    private static final String DingTalk_NOTIFY_API = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    private AtomicReference<String> accessToken = new AtomicReference();
    private long refreshTokenTime;
    private long tokenTimeOut = Duration.ofSeconds(7000L).toMillis();

    public DingTalkProvider(Context properties) {
        super(properties);
    }

    @Override
    public Message send(DingTalkProperty entity) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("access_token", entity.getToken());
        param.put("agent_id", entity.getAgentId());
        param.put("msg", entity.getMsg());
        if (StringKit.isNotBlank((CharSequence)entity.getUserIdList())) {
            param.put("userid_list", entity.getUserIdList());
        }
        if (StringKit.isNotBlank((CharSequence)entity.getDeptIdList())) {
            param.put("dept_id_list", entity.getDeptIdList());
        }
        param.put("to_all_user", entity.isToAllUser());
        String response = Httpx.post((String)DingTalk_NOTIFY_API, param);
        String errcode = (String)JsonKit.getValue((String)response, (String)"errcode");
        return Message.builder().errcode(SUCCESS_RESULT.equals(errcode) ? Builder.ErrorCode.SUCCESS.getCode() : errcode).errmsg((String)JsonKit.getValue((String)response, (String)"errmsg")).build();
    }

    private String getToken() {
        if (System.currentTimeMillis() - this.refreshTokenTime > this.tokenTimeOut || this.accessToken.get() == null) {
            return this.requestToken();
        }
        return this.accessToken.get();
    }

    private String requestToken() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("corpid", this.properties.getAppKey());
        paramMap.put("corpsecret", this.properties.getAppSecret());
        String response = Httpx.get((String)DINGTALK_TOKEN_API, paramMap);
        String errcode = (String)JsonKit.getValue((String)response, (String)"errcode");
        if (SUCCESS_RESULT.equals(errcode)) {
            String access_token = (String)JsonKit.getValue((String)response, (String)"access_token");
            this.refreshTokenTime = System.currentTimeMillis();
            this.accessToken.set(access_token);
            return access_token;
        }
        Logger.error((String)"\u83b7\u53d6\u9489\u9489token\u5931\u8d25\uff1a{}", (Object[])((Object[])JsonKit.getValue((String)response, (String)"errmsg")));
        return null;
    }

    public void setAccessToken(AtomicReference<String> accessToken) {
        this.accessToken = accessToken;
    }

    public void setRefreshTokenTime(long refreshTokenTime) {
        this.refreshTokenTime = refreshTokenTime;
    }

    public void setTokenTimeOut(long tokenTimeOut) {
        this.tokenTimeOut = tokenTimeOut;
    }
}

