/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.generic;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Property;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.generic.NativeEmailProperty;

public class NativeEmailProvider
extends AbstractProvider<NativeEmailProperty, Context> {
    public NativeEmailProvider(Context properties) {
        super(properties);
    }

    @Override
    public org.aoju.bus.notify.magic.Message send(NativeEmailProperty entity) {
        try {
            Transport.send((Message)this.build(entity));
        }
        catch (MessagingException e) {
            String message = e.getMessage();
            if (e instanceof SendFailedException) {
                Address[] invalidAddresses = ((SendFailedException)e).getInvalidAddresses();
                message = StringKit.format((CharSequence)"Invalid Addresses: {}", (Object[])new Object[]{ArrayKit.toString((Object)invalidAddresses)});
            }
            Logger.error((String)message, (Object[])new Object[0]);
        }
        return org.aoju.bus.notify.magic.Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
    }

    public InternetAddress[] getAddress(String address, Charset charset) {
        Object[] addresses;
        try {
            addresses = InternetAddress.parse((String)address);
        }
        catch (AddressException e) {
            throw new InstrumentException((Throwable)e);
        }
        if (ArrayKit.isNotEmpty((Object[])addresses)) {
            for (Object internetAddress : addresses) {
                try {
                    internetAddress.setPersonal(internetAddress.getPersonal(), charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new InstrumentException((Throwable)e);
                }
            }
        }
        return addresses;
    }

    private InternetAddress[] getAddress(String[] address, Charset charset) {
        ArrayList<Object> resultList = new ArrayList<Object>(address.length);
        for (int i = 0; i < address.length; ++i) {
            Object[] addrs = this.getAddress(address[i], charset);
            if (!ArrayKit.isNotEmpty((Object[])addrs)) continue;
            for (int j = 0; j < addrs.length; ++j) {
                resultList.add(addrs[j]);
            }
        }
        return resultList.toArray(new InternetAddress[resultList.size()]);
    }

    private InternetAddress getFirstAddress(String address, Charset charset) {
        Object[] internetAddresses = this.getAddress(address, charset);
        if (ArrayKit.isEmpty((Object[])internetAddresses)) {
            try {
                return new InternetAddress(address);
            }
            catch (AddressException e) {
                throw new InstrumentException((Throwable)e);
            }
        }
        return internetAddresses[0];
    }

    private MimeMessage build(NativeEmailProperty entity) throws MessagingException {
        entity.defaultIfEmpty();
        Charset charset = entity.getCharset();
        MimeMessage msg = new MimeMessage(this.getSession(entity));
        String from = entity.getSender();
        if (StringKit.isEmpty((CharSequence)from)) {
            msg.setFrom();
        } else {
            msg.setFrom((Address)this.getFirstAddress(from, charset));
        }
        msg.setSubject(entity.getTitle(), charset.name());
        msg.setSentDate(new Date());
        MimeMultipart mainPart = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Object)entity.getContent(), StringKit.format((CharSequence)"text/{}; charset={}", (Object[])new Object[]{Property.Type.HTML.equals((Object)entity.getType()) ? "html" : "plain", entity.getCharset()}));
        mainPart.addBodyPart((BodyPart)body);
        if (ArrayKit.isNotEmpty((Object[])entity.getAttachments())) {
            for (File file : entity.getAttachments()) {
                FileDataSource dataSource = new FileDataSource(file);
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                try {
                    bodyPart.setFileName(MimeUtility.encodeText((String)dataSource.getName(), (String)entity.getCharset().name(), null));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                mainPart.addBodyPart((BodyPart)bodyPart);
            }
        }
        msg.setContent((Multipart)mainPart);
        msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])this.getAddress(StringKit.splitToArray((CharSequence)entity.getReceive(), (CharSequence)","), charset));
        if (StringKit.isNotEmpty((CharSequence)entity.getCcs())) {
            msg.setRecipients(MimeMessage.RecipientType.CC, (Address[])this.getAddress(StringKit.splitToArray((CharSequence)entity.getCcs(), (CharSequence)","), charset));
        }
        if (StringKit.isNotEmpty((CharSequence)entity.getBccs())) {
            msg.setRecipients(MimeMessage.RecipientType.BCC, (Address[])this.getAddress(StringKit.splitToArray((CharSequence)entity.getBccs(), (CharSequence)","), charset));
        }
        return msg;
    }

    private Session getSession(NativeEmailProperty template) {
        UserPassAuthenticator authenticator = null;
        if (template.getAuth().booleanValue()) {
            authenticator = new UserPassAuthenticator(template.getUser(), template.getPass());
        }
        return template.isUseGlobalSession() ? Session.getDefaultInstance((Properties)template.getSmtpProps(), authenticator) : Session.getInstance((Properties)template.getSmtpProps(), authenticator);
    }

    class UserPassAuthenticator
    extends Authenticator {
        private final String user;
        private final String pass;

        public UserPassAuthenticator(String user, String pass) {
            this.user = user;
            this.pass = pass;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.pass);
        }
    }
}

