/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.dingtalk;

import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.dingtalk.DingTalkProperty;

public class DingTalkProvider
extends AbstractProvider<DingTalkProperty, Context> {
    private AtomicReference<String> accessToken = new AtomicReference();
    private long refreshTokenTime;
    private long tokenTimeOut = Duration.ofSeconds(7000L).toMillis();

    public DingTalkProvider(Context properties) {
        super(properties);
    }

    @Override
    public Message send(DingTalkProperty entity) {
        HashMap<String, Object> bodys = new HashMap<String, Object>();
        bodys.put("access_token", entity.getToken());
        bodys.put("agent_id", entity.getAgentId());
        bodys.put("msg", entity.getMsg());
        if (StringKit.isNotBlank((CharSequence)entity.getUserIdList())) {
            bodys.put("userid_list", entity.getUserIdList());
        }
        if (StringKit.isNotBlank((CharSequence)entity.getDeptIdList())) {
            bodys.put("dept_id_list", entity.getDeptIdList());
        }
        bodys.put("to_all_user", entity.isToAllUser());
        String response = Httpx.post((String)entity.getUrl(), bodys);
        String errcode = (String)JsonKit.getValue((String)response, (String)"errcode");
        return Message.builder().errcode(String.valueOf(200).equals(errcode) ? Builder.ErrorCode.SUCCESS.getCode() : errcode).errmsg((String)JsonKit.getValue((String)response, (String)"errmsg")).build();
    }

    private String getToken(String url) {
        if (System.currentTimeMillis() - this.refreshTokenTime > this.tokenTimeOut || null == this.accessToken.get()) {
            return this.requestToken(url);
        }
        return this.accessToken.get();
    }

    private String requestToken(String url) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("corpid", this.context.getAppKey());
        paramMap.put("corpsecret", this.context.getAppSecret());
        String response = Httpx.get((String)url, paramMap);
        String errcode = (String)JsonKit.getValue((String)response, (String)"errcode");
        if (String.valueOf(200).equals(errcode)) {
            String access_token = (String)JsonKit.getValue((String)response, (String)"access_token");
            this.refreshTokenTime = System.currentTimeMillis();
            this.accessToken.set(access_token);
            return access_token;
        }
        Logger.error((String)"\u83b7\u53d6\u9489\u9489token\u5931\u8d25\uff1a{}", (Object[])((Object[])JsonKit.getValue((String)response, (String)"errmsg")));
        return null;
    }

    public void setAccessToken(AtomicReference<String> accessToken) {
        this.accessToken = accessToken;
    }

    public void setRefreshTokenTime(long refreshTokenTime) {
        this.refreshTokenTime = refreshTokenTime;
    }

    public void setTokenTimeOut(long tokenTimeOut) {
        this.tokenTimeOut = tokenTimeOut;
    }
}

