/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.jpush;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Objects;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.jpush.JpushProperty;

public class JpushSmsProvider
extends AbstractProvider<JpushProperty, Context> {
    public JpushSmsProvider(Context context) {
        super(context);
    }

    @Override
    public Message send(JpushProperty entity) {
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("sign_id", entity.getSignature());
        bodys.put("mobile", entity.getReceive());
        bodys.put("temp_id", entity.getTemplate());
        bodys.put("temp_para", entity.getParams());
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Basic " + this.getSign());
        String response = Httpx.post((String)entity.getUrl(), bodys, headers);
        boolean succeed = Objects.equals(JsonKit.getValue((String)response, (String)"success_count"), 0);
        String errcode = succeed ? Builder.ErrorCode.SUCCESS.getCode() : Builder.ErrorCode.FAILURE.getCode();
        String errmsg = succeed ? Builder.ErrorCode.SUCCESS.getMsg() : Builder.ErrorCode.FAILURE.getMsg();
        return Message.builder().errcode(errcode).errmsg(errmsg).build();
    }

    private String getSign() {
        String origin = this.context.getAppKey() + ":" + this.context.getAppSecret();
        return Base64.getEncoder().encodeToString(origin.getBytes(StandardCharsets.UTF_8));
    }
}

