/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.huawei;

import java.security.MessageDigest;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.ZoneId;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.huawei.HuaweiProperty;

public class HuaweiSmsProvider
extends AbstractProvider<HuaweiProperty, Context> {
    public static final String SUCCESS_CODE = "000000";
    private static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
    private static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";

    public HuaweiSmsProvider(Context properties) {
        super(properties);
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            String temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                sb.append("0");
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    @Override
    public Message send(HuaweiProperty entity) {
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("from", entity.getSender());
        bodys.put("to", entity.getReceive());
        bodys.put("templateId", entity.getTemplate());
        bodys.put("templateParas", entity.getParams());
        bodys.put("signature", entity.getSignature());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Authorization", AUTH_HEADER_VALUE);
        headers.put("X-WSSE", this.buildWsseHeader());
        String response = Httpx.post((String)entity.getUrl(), bodys, headers);
        String errcode = (String)JsonKit.getValue((String)response, (String)"code");
        return Message.builder().errcode(SUCCESS_CODE.equals(errcode) ? Builder.ErrorCode.SUCCESS.getCode() : errcode).errmsg((String)JsonKit.getValue((String)response, (String)"description")).build();
    }

    private String buildWsseHeader() {
        try {
            String time = DateKit.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (String)ZoneId.GMT.name());
            String nonce = UUID.randomUUID().toString().replace("-", "");
            String text = nonce + time + this.context.getAppSecret();
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(text.getBytes(Charset.UTF_8));
            String hexDigest = HuaweiSmsProvider.byte2Hex(digest.digest());
            String passwordDigestBase64Str = Base64.getEncoder().encodeToString(hexDigest.getBytes());
            return String.format(WSSE_HEADER_FORMAT, this.context.getAppKey(), passwordDigestBase64Str, nonce, time);
        }
        catch (Exception e) {
            throw new InstrumentException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

