/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.aliyun;

import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.aoju.bus.core.lang.ZoneId;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.aliyun.AliyunProperty;
import org.aoju.bus.notify.provider.aliyun.AliyunProvider;

public class AliyunSmsProvider
extends AliyunProvider<AliyunProperty, Context> {
    public AliyunSmsProvider(Context context) {
        super(context);
    }

    @Override
    public Message send(AliyunProperty entity) {
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("SignatureMethod", "HMAC-SHA1");
        bodys.put("SignatureNonce", UUID.randomUUID().toString());
        bodys.put("AccessKeyId", this.context.getAppKey());
        bodys.put("SignatureVersion", "1.0");
        bodys.put("Timestamp", DateKit.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (String)ZoneId.GMT.name()));
        bodys.put("Format", "JSON");
        bodys.put("Action", "SendSms");
        bodys.put("Version", "2017-05-25");
        bodys.put("RegionId", "cn-hangzhou");
        bodys.put("PhoneNumbers", entity.getReceive());
        bodys.put("SignName", entity.getSignature());
        bodys.put("TemplateParam", entity.getParams());
        bodys.put("TemplateCode", entity.getTemplate());
        bodys.put("Signature", this.getSign(bodys));
        HashMap<String, String> map = new HashMap<String, String>();
        for (String text : bodys.keySet()) {
            map.put(this.specialUrlEncode(text), this.specialUrlEncode((String)bodys.get(text)));
        }
        return this.checkResponse(Httpx.get((String)entity.getUrl(), map));
    }
}

