/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.proxy;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pager.Dialect;
import org.aoju.bus.pager.PageException;
import org.aoju.bus.pager.dialect.AbstractPaging;
import org.aoju.bus.pager.dialect.base.Db2;
import org.aoju.bus.pager.dialect.base.HerdDB;
import org.aoju.bus.pager.dialect.base.Hsqldb;
import org.aoju.bus.pager.dialect.base.Informix;
import org.aoju.bus.pager.dialect.base.MySql;
import org.aoju.bus.pager.dialect.base.Oracle;
import org.aoju.bus.pager.dialect.base.Oracle9i;
import org.aoju.bus.pager.dialect.base.Oscar;
import org.aoju.bus.pager.dialect.base.PostgreSql;
import org.aoju.bus.pager.dialect.base.SqlServer;
import org.aoju.bus.pager.dialect.base.SqlServer2012;
import org.apache.ibatis.mapping.MappedStatement;

public class PageAutoDialect {
    private static Map<String, Class<? extends Dialect>> dialectAliasMap = new HashMap<String, Class<? extends Dialect>>();
    private boolean autoDialect = true;
    private boolean closeConn = true;
    private Properties properties;
    private Map<String, AbstractPaging> urlDialectMap = new ConcurrentHashMap<String, AbstractPaging>();
    private ReentrantLock lock = new ReentrantLock();
    private AbstractPaging delegate;
    private ThreadLocal<AbstractPaging> dialectThreadLocal = new ThreadLocal();

    public static void registerDialectAlias(String alias, Class<? extends Dialect> dialectClass) {
        dialectAliasMap.put(alias, dialectClass);
    }

    public void initDelegateDialect(MappedStatement ms) {
        if (this.delegate == null) {
            if (this.autoDialect) {
                this.delegate = this.getDialect(ms);
            } else {
                this.dialectThreadLocal.set(this.getDialect(ms));
            }
        }
    }

    public AbstractPaging getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.dialectThreadLocal.get();
    }

    public void clearDelegate() {
        this.dialectThreadLocal.remove();
    }

    private String fromJdbcUrl(String jdbcUrl) {
        String url = jdbcUrl.toLowerCase();
        for (String dialect : dialectAliasMap.keySet()) {
            if (!url.contains(":" + dialect.toLowerCase() + ":")) continue;
            return dialect;
        }
        return null;
    }

    private Class resloveDialectClass(String className) throws Exception {
        if (dialectAliasMap.containsKey(className.toLowerCase())) {
            return dialectAliasMap.get(className.toLowerCase());
        }
        return Class.forName(className);
    }

    private AbstractPaging initDialect(String dialectClass, Properties properties) {
        AbstractPaging dialect;
        if (StringKit.isEmpty((CharSequence)dialectClass)) {
            throw new PageException("\u4f7f\u7528 PageHelper \u5206\u9875\u63d2\u4ef6\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e helper \u5c5e\u6027");
        }
        try {
            Class sqlDialectClass = this.resloveDialectClass(dialectClass);
            if (!AbstractPaging.class.isAssignableFrom(sqlDialectClass)) {
                throw new PageException("\u4f7f\u7528 PageContext \u65f6\uff0c\u65b9\u8a00\u5fc5\u987b\u662f\u5b9e\u73b0 " + AbstractPaging.class.getCanonicalName() + " \u63a5\u53e3\u7684\u5b9e\u73b0\u7c7b!");
            }
            dialect = (AbstractPaging)sqlDialectClass.newInstance();
        }
        catch (Exception e) {
            throw new PageException("\u521d\u59cb\u5316 [" + dialectClass + "]\u65f6\u51fa\u9519:" + e.getMessage(), e);
        }
        dialect.setProperties(properties);
        return dialect;
    }

    private String getUrl(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new PageException(e);
        }
        finally {
            if (null != conn) {
                try {
                    if (this.closeConn) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractPaging getDialect(MappedStatement ms) {
        DataSource dataSource = ms.getConfiguration().getEnvironment().getDataSource();
        String url = this.getUrl(dataSource);
        if (this.urlDialectMap.containsKey(url)) {
            return this.urlDialectMap.get(url);
        }
        try {
            this.lock.lock();
            if (this.urlDialectMap.containsKey(url)) {
                AbstractPaging abstractPaging = this.urlDialectMap.get(url);
                return abstractPaging;
            }
            if (StringKit.isEmpty((CharSequence)url)) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6jdbcUrl\uff0c\u8bf7\u5728\u5206\u9875\u63d2\u4ef6\u4e2d\u914d\u7f6edialect\u53c2\u6570!");
            }
            String dialectStr = this.fromJdbcUrl(url);
            if (dialectStr == null) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u8bf7\u901a\u8fc7 delegate \u53c2\u6570\u6307\u5b9a!");
            }
            AbstractPaging dialect = this.initDialect(dialectStr, this.properties);
            this.urlDialectMap.put(url, dialect);
            AbstractPaging abstractPaging = dialect;
            return abstractPaging;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setProperties(Properties properties) {
        String dialectAlias;
        String useSqlserver2012;
        String closeConn = properties.getProperty("closeConn");
        if (StringKit.isNotEmpty((CharSequence)closeConn)) {
            this.closeConn = Boolean.parseBoolean(closeConn);
        }
        if (StringKit.isNotEmpty((CharSequence)(useSqlserver2012 = properties.getProperty("useSqlserver2012"))) && Boolean.parseBoolean(useSqlserver2012)) {
            PageAutoDialect.registerDialectAlias("sqlserver", SqlServer2012.class);
            PageAutoDialect.registerDialectAlias("sqlserver2008", SqlServer.class);
        }
        if (StringKit.isNotEmpty((CharSequence)(dialectAlias = properties.getProperty("dialectAlias")))) {
            String[] alias = dialectAlias.split(";");
            for (int i = 0; i < alias.length; ++i) {
                String[] kv = alias[i].split("=");
                if (kv.length != 2) {
                    throw new IllegalArgumentException("dialectAlias \u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u6309\u7167 alias1=xx.dialectClass;alias2=dialectClass2 \u7684\u5f62\u5f0f\u8fdb\u884c\u914d\u7f6e!");
                }
                for (int j = 0; j < kv.length; ++j) {
                    try {
                        Class<?> diallectClass = Class.forName(kv[1]);
                        PageAutoDialect.registerDialectAlias(kv[0], diallectClass);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("\u8bf7\u786e\u4fdd dialectAlias \u914d\u7f6e\u7684 Dialect \u5b9e\u73b0\u7c7b\u5b58\u5728!", e);
                    }
                }
            }
        }
        String dialect = properties.getProperty("delegate");
        String runtimeDialect = properties.getProperty("autoRuntimeDialect");
        if (StringKit.isNotEmpty((CharSequence)runtimeDialect) && "TRUE".equalsIgnoreCase(runtimeDialect)) {
            this.autoDialect = false;
            this.properties = properties;
        } else if (StringKit.isEmpty((CharSequence)dialect)) {
            this.autoDialect = true;
            this.properties = properties;
        } else {
            this.autoDialect = false;
            this.delegate = this.initDialect(dialect, properties);
        }
    }

    static {
        PageAutoDialect.registerDialectAlias("hsqldb", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("h2", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("phoenix", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("postgresql", PostgreSql.class);
        PageAutoDialect.registerDialectAlias("mysql", MySql.class);
        PageAutoDialect.registerDialectAlias("mariadb", MySql.class);
        PageAutoDialect.registerDialectAlias("sqlite", MySql.class);
        PageAutoDialect.registerDialectAlias("herddb", HerdDB.class);
        PageAutoDialect.registerDialectAlias("oracle", Oracle.class);
        PageAutoDialect.registerDialectAlias("oracle9i", Oracle9i.class);
        PageAutoDialect.registerDialectAlias("db2", Db2.class);
        PageAutoDialect.registerDialectAlias("informix", Informix.class);
        PageAutoDialect.registerDialectAlias("informix-sqli", Informix.class);
        PageAutoDialect.registerDialectAlias("sqlserver", SqlServer.class);
        PageAutoDialect.registerDialectAlias("sqlserver2012", SqlServer2012.class);
        PageAutoDialect.registerDialectAlias("derby", SqlServer2012.class);
        PageAutoDialect.registerDialectAlias("dm", Oracle.class);
        PageAutoDialect.registerDialectAlias("edb", Oracle.class);
        PageAutoDialect.registerDialectAlias("oscar", Oscar.class);
        PageAutoDialect.registerDialectAlias("clickhouse", MySql.class);
        PageAutoDialect.registerDialectAlias("highgo", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("xugu", Hsqldb.class);
    }
}

