/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.proxy.provider.remoting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.proxy.Builder;
import org.aoju.bus.proxy.Provider;

public class SessionBeanProvider
implements Provider {
    private final String jndiName;
    private final Class homeInterface;
    private final Properties properties;

    public SessionBeanProvider(String jndiName, Class homeInterface) {
        this.jndiName = jndiName;
        this.homeInterface = homeInterface;
        this.properties = null;
    }

    public SessionBeanProvider(String jndiName, Class homeInterface, Properties properties) {
        this.jndiName = jndiName;
        this.homeInterface = homeInterface;
        this.properties = properties;
    }

    @Override
    public Object getObject() {
        try {
            InitialContext initialContext = this.properties == null ? new InitialContext() : new InitialContext(this.properties);
            Object homeObject = PortableRemoteObject.narrow((Object)initialContext.lookup(this.jndiName), (Class)this.homeInterface);
            Method createMethod = homeObject.getClass().getMethod("create", Builder.EMPTY_ARGUMENT_TYPES);
            return createMethod.invoke(homeObject, Builder.EMPTY_ARGUMENTS);
        }
        catch (NoSuchMethodException e) {
            throw new InstrumentException("Unable to find no-arg create() method on home interface " + this.homeInterface.getName() + ".", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InstrumentException("No-arg create() method on home interface " + this.homeInterface.getName() + " is not accessible.", (Throwable)e);
        }
        catch (NamingException e) {
            throw new InstrumentException("Unable to lookup EJB home object in JNDI.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new InstrumentException("No-arg create() method on home interface " + this.homeInterface.getName() + " threw an exception.", (Throwable)e);
        }
    }
}

