/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.proxy.factory;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.aoju.bus.proxy.factory.MethodSignature;
import org.aoju.bus.proxy.factory.ProxyClass;

public abstract class AbstractProxyClass
implements ProxyClass {
    public static Method[] getImplementationMethods(Class[] proxyClasses) {
        HashMap<MethodSignature, Method> signatureMethodMap = new HashMap<MethodSignature, Method>();
        HashSet<MethodSignature> finalizedSignatures = new HashSet<MethodSignature>();
        for (int i = 0; i < proxyClasses.length; ++i) {
            Class proxyInterface = proxyClasses[i];
            Method[] methods = proxyInterface.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                MethodSignature signature = new MethodSignature(methods[j]);
                if (Modifier.isFinal(methods[j].getModifiers())) {
                    finalizedSignatures.add(signature);
                    continue;
                }
                if (signatureMethodMap.containsKey(signature)) continue;
                signatureMethodMap.put(signature, methods[j]);
            }
        }
        Collection resultingMethods = signatureMethodMap.values();
        for (MethodSignature signature : finalizedSignatures) {
            resultingMethods.remove(signatureMethodMap.get(signature));
        }
        return resultingMethods.toArray(new Method[resultingMethods.size()]);
    }
}

