/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.proxy.factory.javassist;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.proxy.Builder;
import org.aoju.bus.proxy.Invocation;
import org.aoju.bus.proxy.factory.javassist.JavassistUtils;

public abstract class JavassistInvocation
implements Invocation {
    private static WeakHashMap loaderToClassCache = new WeakHashMap();
    protected final Method method;
    protected final Object target;
    protected final Object[] arguments;

    public JavassistInvocation(Method method, Object target, Object[] arguments) {
        this.method = method;
        this.target = target;
        this.arguments = arguments;
    }

    private static String createCastExpression(Class type, String objectToCast) {
        if (!type.isPrimitive()) {
            return "( " + Builder.getJavaClassName(type) + " )" + objectToCast;
        }
        return "( ( " + Builder.getWrapperClass(type).getName() + " )" + objectToCast + " )." + type.getName() + "Value()";
    }

    private static Class createInvocationClass(ClassLoader classLoader, Method interfaceMethod) throws CannotCompileException {
        CtClass ctClass = JavassistUtils.createClass(JavassistInvocation.getSimpleName(interfaceMethod.getDeclaringClass()) + "_" + interfaceMethod.getName() + "_invocation", JavassistInvocation.class);
        CtConstructor constructor = new CtConstructor(JavassistUtils.resolve(new Class[]{Method.class, Object.class, Object[].class}), ctClass);
        constructor.setBody("{\n\tsuper($$);\n}");
        ctClass.addConstructor(constructor);
        CtMethod proceedMethod = new CtMethod(JavassistUtils.resolve(Object.class), "proceed", JavassistUtils.resolve(Normal.EMPTY_CLASS_ARRAY), ctClass);
        Class<?>[] argumentTypes = interfaceMethod.getParameterTypes();
        StringBuffer proceedBody = new StringBuffer("{\n");
        if (!Void.TYPE.equals(interfaceMethod.getReturnType())) {
            proceedBody.append("\treturn ");
            if (interfaceMethod.getReturnType().isPrimitive()) {
                proceedBody.append("new ");
                proceedBody.append(Builder.getWrapperClass(interfaceMethod.getReturnType()).getName());
                proceedBody.append("( ");
            }
        } else {
            proceedBody.append("\t");
        }
        proceedBody.append("( (");
        proceedBody.append(Builder.getJavaClassName(interfaceMethod.getDeclaringClass()));
        proceedBody.append(" )target ).");
        proceedBody.append(interfaceMethod.getName());
        proceedBody.append("(");
        for (int i = 0; i < argumentTypes.length; ++i) {
            Class<?> argumentType = argumentTypes[i];
            proceedBody.append(JavassistInvocation.createCastExpression(argumentType, "arguments[" + i + "]"));
            if (i == argumentTypes.length - 1) continue;
            proceedBody.append(", ");
        }
        if (!Void.TYPE.equals(interfaceMethod.getReturnType()) && interfaceMethod.getReturnType().isPrimitive()) {
            proceedBody.append(") );\n");
        } else {
            proceedBody.append(");\n");
        }
        if (Void.TYPE.equals(interfaceMethod.getReturnType())) {
            proceedBody.append("\treturn null;\n");
        }
        proceedBody.append("}");
        String body = proceedBody.toString();
        proceedMethod.setBody(body);
        ctClass.addMethod(proceedMethod);
        Class invocationClass = ctClass.toClass(classLoader, null);
        return invocationClass;
    }

    private static Map getClassCache(ClassLoader classLoader) {
        HashMap cache = (HashMap)loaderToClassCache.get(classLoader);
        if (cache == null) {
            cache = new HashMap();
            loaderToClassCache.put(classLoader, cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Class getMethodInvocationClass(ClassLoader classLoader, Method interfaceMethod) throws CannotCompileException {
        Class invocationClass;
        String key;
        Map classCache = JavassistInvocation.getClassCache(classLoader);
        WeakReference invocationClassRef = (WeakReference)classCache.get(key = JavassistInvocation.toClassCacheKey(interfaceMethod));
        if (invocationClassRef == null) {
            invocationClass = JavassistInvocation.createInvocationClass(classLoader, interfaceMethod);
            classCache.put(key, new WeakReference<Class>(invocationClass));
        } else {
            WeakReference weakReference = invocationClassRef;
            synchronized (weakReference) {
                invocationClass = (Class)invocationClassRef.get();
                if (invocationClass == null) {
                    invocationClass = JavassistInvocation.createInvocationClass(classLoader, interfaceMethod);
                    classCache.put(key, new WeakReference<Class>(invocationClass));
                }
            }
        }
        return invocationClass;
    }

    private static String getSimpleName(Class c) {
        String name = c.getName();
        int ndx = name.lastIndexOf(46);
        return ndx == -1 ? name : name.substring(ndx + 1);
    }

    private static String toClassCacheKey(Method method) {
        return String.valueOf(method);
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object getProxy() {
        return this.target;
    }
}

