/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.proxy.invoker;

import java.lang.reflect.Method;
import org.aoju.bus.proxy.Invoker;
import org.aoju.bus.proxy.Provider;

public class DuckInvoker
implements Invoker {
    private final Provider targetProvider;

    public DuckInvoker(Provider targetProvider) {
        this.targetProvider = targetProvider;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Object target = this.targetProvider.getObject();
        Class<?> targetClass = target.getClass();
        try {
            Method targetMethod = targetClass.getMethod(method.getName(), method.getParameterTypes());
            if (method.getReturnType().isAssignableFrom(targetMethod.getReturnType())) {
                return targetMethod.invoke(target, arguments);
            }
            throw new UnsupportedOperationException("Target type " + targetClass.getName() + " method has incompatible return type.");
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Target type " + targetClass.getName() + " does not have a method matching " + method + ".");
        }
    }
}

