/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.proxy.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.proxy.Factory;
import org.aoju.bus.proxy.aspects.Aspectj;
import org.aoju.bus.proxy.factory.cglib.CglibFactory;
import org.aoju.bus.proxy.factory.javassist.JavassistFactory;

public abstract class AbstractFactory
extends Factory {
    private static boolean hasSuitableDefaultConstructor(Class superclass) {
        Constructor<?>[] declaredConstructors = superclass.getDeclaredConstructors();
        for (int i = 0; i < declaredConstructors.length; ++i) {
            Constructor<?> constructor = declaredConstructors[i];
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers()) && !Modifier.isProtected(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    protected static Class[] toInterfaces(Class[] proxyClasses) {
        LinkedList<Class> interfaces = new LinkedList<Class>();
        for (int i = 0; i < proxyClasses.length; ++i) {
            Class proxyInterface = proxyClasses[i];
            if (!proxyInterface.isInterface()) continue;
            interfaces.add(proxyInterface);
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private static Class[] toNonInterfaces(Class[] proxyClasses) {
        LinkedList<Class> superclasses = new LinkedList<Class>();
        for (int i = 0; i < proxyClasses.length; ++i) {
            Class proxyClass = proxyClasses[i];
            if (proxyClass.isInterface()) continue;
            superclasses.add(proxyClass);
        }
        return superclasses.toArray(new Class[superclasses.size()]);
    }

    public static Class getSuperclass(Class[] proxyClasses) {
        Class[] superclasses = AbstractFactory.toNonInterfaces(proxyClasses);
        switch (superclasses.length) {
            case 0: {
                return Object.class;
            }
            case 1: {
                Class superclass = superclasses[0];
                if (Modifier.isFinal(superclass.getModifiers())) {
                    throw new InstrumentException("Proxy class cannot extend " + superclass.getName() + " as it is final.");
                }
                if (!AbstractFactory.hasSuitableDefaultConstructor(superclass)) {
                    throw new InstrumentException("Proxy class cannot extend " + superclass.getName() + ", because it has no visible \"default\" constructor.");
                }
                return superclass;
            }
        }
        StringBuffer errorMessage = new StringBuffer("Proxy class cannot extend ");
        for (int i = 0; i < superclasses.length; ++i) {
            Class c = superclasses[i];
            errorMessage.append(c.getName());
            if (i == superclasses.length - 1) continue;
            errorMessage.append(", ");
        }
        errorMessage.append("; multiple inheritance not allowed.");
        throw new InstrumentException(errorMessage.toString());
    }

    public static <T> T createProxy(T target, Class<? extends Aspectj> aspectClass) {
        return AbstractFactory.createProxy(target, (Aspectj)ReflectKit.newInstance(aspectClass, (Object[])new Object[0]));
    }

    public static <T> T createProxy(T target, Aspectj aspectj) {
        return AbstractFactory.create().proxy(target, aspectj);
    }

    public static AbstractFactory create() {
        try {
            return new CglibFactory();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new JavassistFactory();
        }
    }

    public static <T> T proxy(T target, Class<? extends Aspectj> aspectClass) {
        return AbstractFactory.createProxy(target, aspectClass);
    }

    public static <T> T newProxyInstance(ClassLoader classloader, InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return (T)Proxy.newProxyInstance(classloader, interfaces, invocationHandler);
    }

    public static <T> T newProxyInstance(InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return AbstractFactory.newProxyInstance(ClassKit.getClassLoader(), invocationHandler, interfaces);
    }

    @Override
    public boolean canProxy(Class[] proxyClasses) {
        try {
            AbstractFactory.getSuperclass(proxyClasses);
            return true;
        }
        catch (InstrumentException e) {
            return false;
        }
    }

    public abstract <T> T proxy(T var1, Aspectj var2);
}

