/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.proxy.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.proxy.Builder;
import org.aoju.bus.proxy.Provider;

public class CloningProvider
implements Provider {
    private final Cloneable cloneable;
    private Method cloneMethod;

    public CloningProvider(Cloneable cloneable) {
        this.cloneable = cloneable;
    }

    private synchronized Method getCloneMethod() {
        if (null == this.cloneMethod) {
            try {
                this.cloneMethod = this.cloneable.getClass().getMethod("clone", Builder.EMPTY_ARGUMENT_TYPES);
            }
            catch (NoSuchMethodException e) {
                throw new InstrumentException("Class " + this.cloneable.getClass().getName() + " does not have a public clone() method.");
            }
        }
        return this.cloneMethod;
    }

    @Override
    public Object getObject() {
        try {
            return this.getCloneMethod().invoke((Object)this.cloneable, Builder.EMPTY_ARGUMENTS);
        }
        catch (IllegalAccessException e) {
            throw new InstrumentException("Class " + this.cloneable.getClass().getName() + " does not have a public clone() method.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new InstrumentException("Attempt to clone object of type " + this.cloneable.getClass().getName() + " threw an exception.", (Throwable)e);
        }
    }
}

