/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.proxy.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.proxy.Builder;
import org.aoju.bus.proxy.Provider;

public class SessionBeanProvider
implements Provider {
    private final String jndiName;
    private final Class clazz;
    private final Properties properties;

    public SessionBeanProvider(String jndiName, Class clazz) {
        this.jndiName = jndiName;
        this.clazz = clazz;
        this.properties = null;
    }

    public SessionBeanProvider(String jndiName, Class clazz, Properties properties) {
        this.jndiName = jndiName;
        this.clazz = clazz;
        this.properties = properties;
    }

    @Override
    public Object getObject() {
        try {
            InitialContext initialContext = null == this.properties ? new InitialContext() : new InitialContext(this.properties);
            Object homeObject = PortableRemoteObject.narrow((Object)initialContext.lookup(this.jndiName), (Class)this.clazz);
            Method createMethod = homeObject.getClass().getMethod("create", Builder.EMPTY_ARGUMENT_TYPES);
            return createMethod.invoke(homeObject, Builder.EMPTY_ARGUMENTS);
        }
        catch (NoSuchMethodException e) {
            throw new InternalException("Unable to find no-arg create() method on home interface " + this.clazz.getName() + ".", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InternalException("No-arg create() method on home interface " + this.clazz.getName() + " is not accessible.", (Throwable)e);
        }
        catch (NamingException e) {
            throw new InternalException("Unable to lookup EJB home object in JNDI.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new InternalException("No-arg create() method on home interface " + this.clazz.getName() + " threw an exception.", (Throwable)e);
        }
    }
}

