/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.sensitive;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.TypeUtils;
import org.aoju.bus.sensitive.Context;
import org.aoju.bus.sensitive.Filter;
import org.aoju.bus.sensitive.Registry;
import org.aoju.bus.sensitive.annotation.Condition;
import org.aoju.bus.sensitive.annotation.Entry;
import org.aoju.bus.sensitive.annotation.Field;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.sensitive.annotation.Strategy;
import org.aoju.bus.sensitive.provider.ConditionProvider;
import org.aoju.bus.sensitive.provider.StrategyProvider;
import org.aoju.bus.sensitive.strategy.BuiltInStrategy;

public class Provider<T> {
    private String[] value;

    public static <T> T clone(T object) {
        Class<?> clazz = object.getClass();
        String jsonString = JSON.toJSONString(object);
        return (T)JSON.parseObject((String)jsonString, clazz);
    }

    public static boolean alreadyBeSentisived(Object object) {
        return object == null || object.toString().indexOf("*") > 0;
    }

    public static Map<String, Object> parseToObjectMap(String jsonStr) {
        return (Map)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]);
    }

    public static String parseMaptoJSONString(Map<String, Object> params) {
        return JSON.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public T on(T object, Annotation annotation) {
        if (ObjectUtils.isEmpty((Object[])new Object[]{object})) {
            return object;
        }
        if (ObjectUtils.isNotEmpty((Object[])new Object[]{annotation})) {
            Sensitive sensitive = (Sensitive)annotation;
            this.value = sensitive.value();
        }
        Class<?> clazz = object.getClass();
        Context context = new Context();
        T copyObject = Provider.clone(object);
        this.handleClassField(context, copyObject, clazz);
        return copyObject;
    }

    public String json(T object, Annotation annotation) {
        if (ObjectUtils.isEmpty((Object[])new Object[]{object})) {
            return JSON.toJSONString(object);
        }
        if (ObjectUtils.isNotEmpty((Object[])new Object[]{annotation})) {
            Sensitive sensitive = (Sensitive)annotation;
            this.value = sensitive.value();
        }
        Context context = new Context();
        Filter filter = new Filter(context);
        return JSON.toJSONString(object, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
    }

    private void handleClassField(Context context, Object copyObject, Class clazz) {
        List fieldList = ClassUtils.getAllFieldList((Class)clazz);
        context.setAllFieldList(fieldList);
        context.setCurrentObject(copyObject);
        try {
            for (java.lang.reflect.Field field : fieldList) {
                if (ArrayUtils.isNotEmpty((Object[])this.value) && !Arrays.asList(this.value).contains(field.getName())) continue;
                Class<?> fieldTypeClass = field.getType();
                context.setCurrentField(field);
                Entry sensitiveEntry = field.getAnnotation(Entry.class);
                if (ObjectUtils.isNotNull((Object)sensitiveEntry)) {
                    if (TypeUtils.isJavaBean(fieldTypeClass)) {
                        Object fieldNewObject = field.get(copyObject);
                        this.handleClassField(context, fieldNewObject, fieldTypeClass);
                        continue;
                    }
                    if (TypeUtils.isArray(fieldTypeClass)) {
                        Object[] arrays = (Object[])field.get(copyObject);
                        if (!ArrayUtils.isNotEmpty((Object[])arrays)) continue;
                        Object firstArrayEntry = arrays[0];
                        Class<?> entryFieldClass = firstArrayEntry.getClass();
                        if (this.needHandleEntryType(entryFieldClass)) {
                            for (Object arrayEntry : arrays) {
                                this.handleClassField(context, arrayEntry, entryFieldClass);
                            }
                            continue;
                        }
                        int arrayLength = arrays.length;
                        Object newArray = Array.newInstance(entryFieldClass, arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            Object entry = arrays[i];
                            Object result = this.handleSensitiveEntry(context, entry, field);
                            Array.set(newArray, i, result);
                        }
                        field.set(copyObject, newArray);
                        continue;
                    }
                    if (TypeUtils.isCollection(fieldTypeClass)) {
                        Collection entryCollection = (Collection)field.get(copyObject);
                        if (!CollUtils.isNotEmpty((Collection)entryCollection)) continue;
                        Object firstCollectionEntry = entryCollection.iterator().next();
                        Class<?> collectionEntryClass = firstCollectionEntry.getClass();
                        if (this.needHandleEntryType(collectionEntryClass)) {
                            for (Object collectionEntry : entryCollection) {
                                this.handleClassField(context, collectionEntry, collectionEntryClass);
                            }
                            continue;
                        }
                        ArrayList<Object> newResultList = new ArrayList<Object>(entryCollection.size());
                        for (Object entry : entryCollection) {
                            Object result = this.handleSensitiveEntry(context, entry, field);
                            newResultList.add(result);
                        }
                        field.set(copyObject, newResultList);
                        continue;
                    }
                    this.handleSensitive(context, copyObject, field);
                    continue;
                }
                this.handleSensitive(context, copyObject, field);
            }
        }
        catch (IllegalAccessException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    private Object handleSensitiveEntry(Context context, Object entry, java.lang.reflect.Field field) {
        try {
            StrategyProvider strategy;
            Class<? extends ConditionProvider> conditionClass;
            ConditionProvider condition;
            Field sensitive = field.getAnnotation(Field.class);
            if (ObjectUtils.isNotNull((Object)sensitive) && (condition = (conditionClass = sensitive.condition()).newInstance()).valid(context)) {
                Class<? extends StrategyProvider> strategyClass = sensitive.strategy();
                StrategyProvider strategy2 = strategyClass.newInstance();
                return strategy2.build(entry, context);
            }
            Object[] annotations = field.getAnnotations();
            if (ArrayUtils.isNotEmpty((Object[])annotations) && (ObjectUtils.isNull((Object)(condition = this.getCondition((Annotation[])annotations))) || condition.valid(context)) && ObjectUtils.isNotNull((Object)(strategy = this.getStrategy((Annotation[])annotations)))) {
                return strategy.build(entry, context);
            }
            return entry;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    private void handleSensitive(Context context, Object copyObject, java.lang.reflect.Field field) {
        try {
            StrategyProvider strategy;
            Object[] annotations;
            Class<? extends ConditionProvider> conditionClass;
            ConditionProvider condition;
            Field sensitive = field.getAnnotation(Field.class);
            if (sensitive != null && (condition = (conditionClass = sensitive.condition()).newInstance()).valid(context)) {
                Class<? extends StrategyProvider> strategyClass = sensitive.strategy();
                StrategyProvider strategy2 = strategyClass.newInstance();
                Object originalFieldVal = field.get(copyObject);
                Object result = strategy2.build(originalFieldVal, context);
                field.set(copyObject, result);
            }
            if (ArrayUtils.isNotEmpty((Object[])(annotations = field.getAnnotations())) && (ObjectUtils.isNull((Object)(condition = this.getCondition((Annotation[])annotations))) || condition.valid(context)) && ObjectUtils.isNotNull((Object)(strategy = this.getStrategy((Annotation[])annotations)))) {
                Object originalFieldVal = field.get(copyObject);
                Object result = strategy.build(originalFieldVal, context);
                field.set(copyObject, result);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    private StrategyProvider getStrategy(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Strategy strategy = annotation.annotationType().getAnnotation(Strategy.class);
            if (!ObjectUtils.isNotNull((Object)strategy)) continue;
            Class<? extends StrategyProvider> clazz = strategy.value();
            if (BuiltInStrategy.class.equals(clazz)) {
                return Registry.require(annotation.annotationType());
            }
            return (StrategyProvider)ClassUtils.newInstance(clazz);
        }
        return null;
    }

    private ConditionProvider getCondition(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Condition condition = annotation.annotationType().getAnnotation(Condition.class);
            if (!ObjectUtils.isNotNull((Object)condition)) continue;
            Class<? extends ConditionProvider> clazz = condition.value();
            return (ConditionProvider)ClassUtils.newInstance(clazz);
        }
        return null;
    }

    private boolean needHandleEntryType(Class fieldTypeClass) {
        if (TypeUtils.isBase((Class)fieldTypeClass) || TypeUtils.isMap((Class)fieldTypeClass)) {
            return false;
        }
        return TypeUtils.isJavaBean((Class)fieldTypeClass) || TypeUtils.isArray((Class)fieldTypeClass) || TypeUtils.isCollection((Class)fieldTypeClass);
    }
}

