/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.sensitive;

import com.alibaba.fastjson.serializer.BeanContext;
import com.alibaba.fastjson.serializer.ContextValueFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.TypeUtils;
import org.aoju.bus.sensitive.Context;
import org.aoju.bus.sensitive.Registry;
import org.aoju.bus.sensitive.annotation.Condition;
import org.aoju.bus.sensitive.annotation.Entry;
import org.aoju.bus.sensitive.annotation.Shield;
import org.aoju.bus.sensitive.provider.ConditionProvider;
import org.aoju.bus.sensitive.provider.StrategyProvider;

public class Filter
implements ContextValueFilter {
    private final Context sensitiveContext;

    public Filter(Context context) {
        this.sensitiveContext = context;
    }

    private static ConditionProvider getConditionOpt(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Condition sensitiveCondition = annotation.annotationType().getAnnotation(Condition.class);
            if (!ObjectUtils.isNotNull((Object)sensitiveCondition)) continue;
            return (ConditionProvider)ClassUtils.newInstance(sensitiveCondition.value());
        }
        return null;
    }

    public Object process(BeanContext context, Object object, String name, Object value) {
        Object firstCollectionEntry;
        Collection entryCollection;
        Object firstArrayEntry;
        Class<?> entryFieldClass;
        Object[] arrays;
        if (ObjectUtils.isNull((Object)context)) {
            return value;
        }
        Field field = context.getField();
        Class clazz = context.getBeanClass();
        List fieldList = ClassUtils.getAllFieldList((Class)clazz);
        this.sensitiveContext.setCurrentField(field);
        this.sensitiveContext.setCurrentObject(object);
        this.sensitiveContext.setBeanClass(clazz);
        this.sensitiveContext.setAllFieldList(fieldList);
        Entry sensitiveEntry = field.getAnnotation(Entry.class);
        if (ObjectUtils.isNull((Object)sensitiveEntry)) {
            this.sensitiveContext.setEntry(value);
            return this.handleSensitive(this.sensitiveContext, field);
        }
        Class<?> fieldTypeClass = field.getType();
        if (TypeUtils.isJavaBean(fieldTypeClass)) {
            return value;
        }
        if (TypeUtils.isMap(fieldTypeClass)) {
            return value;
        }
        if (TypeUtils.isArray(fieldTypeClass) && ArrayUtils.isNotEmpty((Object[])(arrays = (Object[])value)) && this.isBaseType(entryFieldClass = (firstArrayEntry = ArrayUtils.firstNotNullElem((Object[])arrays).get()).getClass())) {
            int arrayLength = arrays.length;
            Object newArray = Array.newInstance(entryFieldClass, arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Object entry = arrays[i];
                this.sensitiveContext.setEntry(entry);
                Object result = this.handleSensitive(this.sensitiveContext, field);
                Array.set(newArray, i, result);
            }
            return newArray;
        }
        if (TypeUtils.isCollection(fieldTypeClass) && CollUtils.isNotEmpty((Collection)(entryCollection = (Collection)value)) && this.isBaseType((firstCollectionEntry = CollUtils.firstNotNullElem((Collection)entryCollection).get()).getClass())) {
            ArrayList<Object> newResultList = new ArrayList<Object>(entryCollection.size());
            for (Object entry : entryCollection) {
                this.sensitiveContext.setEntry(entry);
                Object result = this.handleSensitive(this.sensitiveContext, field);
                newResultList.add(result);
            }
            return newResultList;
        }
        return value;
    }

    private Object handleSensitive(Context context, Field field) {
        try {
            StrategyProvider strategyProvider;
            ConditionProvider conditionOptional;
            Class<? extends ConditionProvider> conditionClass;
            ConditionProvider condition;
            Object originalFieldVal = context.getEntry();
            Shield sensitive = field.getAnnotation(Shield.class);
            if (ObjectUtils.isNotNull((Object)sensitive) && (condition = (conditionClass = sensitive.condition()).newInstance()).valid(context)) {
                StrategyProvider strategy = Registry.require(sensitive.type());
                if (ObjectUtils.isEmpty((Object[])new Object[]{strategy})) {
                    Class<? extends StrategyProvider> strategyClass = sensitive.strategy();
                    strategy = strategyClass.newInstance();
                }
                this.sensitiveContext.setEntry(null);
                return strategy.build(originalFieldVal, context);
            }
            Object[] annotations = field.getAnnotations();
            if (ArrayUtils.isNotEmpty((Object[])annotations) && ObjectUtils.isNotEmpty((Object[])new Object[]{conditionOptional = Filter.getConditionOpt((Annotation[])annotations)}) && ObjectUtils.isEmpty((Object[])new Object[]{strategyProvider = Registry.require((Annotation[])annotations)})) {
                this.sensitiveContext.setEntry(null);
                return strategyProvider.build(originalFieldVal, context);
            }
            this.sensitiveContext.setEntry(null);
            return originalFieldVal;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    private boolean isBaseType(Class fieldTypeClass) {
        if (TypeUtils.isBase((Class)fieldTypeClass)) {
            return true;
        }
        return !TypeUtils.isJavaBean((Class)fieldTypeClass) && !TypeUtils.isArray((Class)fieldTypeClass) && !TypeUtils.isCollection((Class)fieldTypeClass) && !TypeUtils.isMap((Class)fieldTypeClass);
    }
}

