/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.sensitive;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.TypeKit;
import org.aoju.bus.sensitive.Context;
import org.aoju.bus.sensitive.Filter;
import org.aoju.bus.sensitive.Registry;
import org.aoju.bus.sensitive.annotation.Condition;
import org.aoju.bus.sensitive.annotation.Entry;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.sensitive.annotation.Shield;
import org.aoju.bus.sensitive.annotation.Strategy;
import org.aoju.bus.sensitive.provider.ConditionProvider;
import org.aoju.bus.sensitive.provider.StrategyProvider;
import org.aoju.bus.sensitive.strategy.BuiltInStrategy;

public class Provider<T> {
    private String[] value;

    public static <T> T clone(T object) {
        Class<?> clazz = object.getClass();
        String jsonString = JSON.toJSONString(object);
        return (T)JSON.parseObject((String)jsonString, clazz);
    }

    public static boolean alreadyBeSentisived(Object object) {
        return null == object || object.toString().indexOf("*") > 0;
    }

    public static Map<String, Object> parseToObjectMap(String jsonStr) {
        return (Map)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]);
    }

    public static String parseMaptoJSONString(Map<String, Object> params) {
        return JSON.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public T on(T object, Annotation annotation, boolean clone) {
        if (ObjectKit.isEmpty(object)) {
            return object;
        }
        if (ObjectKit.isNotEmpty((Object)annotation)) {
            Sensitive sensitive = (Sensitive)annotation;
            this.value = sensitive.field();
        }
        Class<?> clazz = object.getClass();
        Context context = new Context();
        if (clone) {
            T copy = Provider.clone(object);
            this.handleClassField(context, copy, clazz);
            return copy;
        }
        this.handleClassField(context, object, clazz);
        return object;
    }

    public String json(T object, Annotation annotation) {
        if (ObjectKit.isEmpty(object)) {
            return JSON.toJSONString(object);
        }
        if (ObjectKit.isNotEmpty((Object)annotation)) {
            Sensitive sensitive = (Sensitive)annotation;
            this.value = sensitive.field();
        }
        Context context = new Context();
        Filter filter = new Filter(context);
        return JSON.toJSONString(object, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
    }

    private void handleClassField(Context context, Object copyObject, Class clazz) {
        List fieldList = ClassKit.getAllFieldList((Class)clazz);
        context.setAllFieldList(fieldList);
        context.setCurrentObject(copyObject);
        try {
            for (Field field : fieldList) {
                if (ArrayKit.isNotEmpty((Object[])this.value) && !Arrays.asList(this.value).contains(field.getName())) continue;
                Class<?> fieldTypeClass = field.getType();
                context.setCurrentField(field);
                Entry sensitiveEntry = field.getAnnotation(Entry.class);
                if (ObjectKit.isNotNull((Object)sensitiveEntry)) {
                    if (TypeKit.isJavaBean(fieldTypeClass)) {
                        Object fieldNewObject = field.get(copyObject);
                        this.handleClassField(context, fieldNewObject, fieldTypeClass);
                        continue;
                    }
                    if (TypeKit.isArray(fieldTypeClass)) {
                        Object[] arrays = (Object[])field.get(copyObject);
                        if (!ArrayKit.isNotEmpty((Object[])arrays)) continue;
                        Object firstArrayEntry = arrays[0];
                        Class<?> entryFieldClass = firstArrayEntry.getClass();
                        if (this.needHandleEntryType(entryFieldClass)) {
                            for (Object arrayEntry : arrays) {
                                this.handleClassField(context, arrayEntry, entryFieldClass);
                            }
                            continue;
                        }
                        int arrayLength = arrays.length;
                        Object newArray = Array.newInstance(entryFieldClass, arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            Object entry = arrays[i];
                            Object result = this.handleSensitiveEntry(context, entry, field);
                            Array.set(newArray, i, result);
                        }
                        field.set(copyObject, newArray);
                        continue;
                    }
                    if (TypeKit.isCollection(fieldTypeClass)) {
                        Collection entryCollection = (Collection)field.get(copyObject);
                        if (!CollKit.isNotEmpty((Collection)entryCollection)) continue;
                        Object firstCollectionEntry = entryCollection.iterator().next();
                        Class<?> collectionEntryClass = firstCollectionEntry.getClass();
                        if (this.needHandleEntryType(collectionEntryClass)) {
                            for (Object collectionEntry : entryCollection) {
                                this.handleClassField(context, collectionEntry, collectionEntryClass);
                            }
                            continue;
                        }
                        ArrayList<Object> newResultList = new ArrayList<Object>(entryCollection.size());
                        for (Object entry : entryCollection) {
                            Object result = this.handleSensitiveEntry(context, entry, field);
                            newResultList.add(result);
                        }
                        field.set(copyObject, newResultList);
                        continue;
                    }
                    this.handleSensitive(context, copyObject, field);
                    continue;
                }
                this.handleSensitive(context, copyObject, field);
            }
        }
        catch (IllegalAccessException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    private Object handleSensitiveEntry(Context context, Object entry, Field field) {
        try {
            StrategyProvider strategy;
            Class<? extends ConditionProvider> conditionClass;
            ConditionProvider condition;
            Shield sensitive = field.getAnnotation(Shield.class);
            if (ObjectKit.isNotNull((Object)sensitive) && (condition = (conditionClass = sensitive.condition()).newInstance()).valid(context)) {
                context.setShield(sensitive);
                Class<? extends StrategyProvider> strategyClass = sensitive.strategy();
                StrategyProvider strategy2 = strategyClass.newInstance();
                return strategy2.build(entry, context);
            }
            Object[] annotations = field.getAnnotations();
            if (ArrayKit.isNotEmpty((Object[])annotations) && (ObjectKit.isNull((Object)(condition = this.getCondition((Annotation[])annotations))) || condition.valid(context)) && ObjectKit.isNotNull((Object)(strategy = this.getStrategy((Annotation[])annotations)))) {
                return strategy.build(entry, context);
            }
            return entry;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    private void handleSensitive(Context context, Object copyObject, Field field) {
        try {
            StrategyProvider strategy;
            Object[] annotations;
            Class<? extends ConditionProvider> conditionClass;
            ConditionProvider condition;
            Shield sensitive = field.getAnnotation(Shield.class);
            if (null != sensitive && (condition = (conditionClass = sensitive.condition()).newInstance()).valid(context)) {
                context.setShield(sensitive);
                Class<? extends StrategyProvider> strategyClass = sensitive.strategy();
                StrategyProvider strategy2 = strategyClass.newInstance();
                Object originalFieldVal = field.get(copyObject);
                Object result = strategy2.build(originalFieldVal, context);
                field.set(copyObject, result);
            }
            if (ArrayKit.isNotEmpty((Object[])(annotations = field.getAnnotations())) && (ObjectKit.isNull((Object)(condition = this.getCondition((Annotation[])annotations))) || condition.valid(context)) && ObjectKit.isNotNull((Object)(strategy = this.getStrategy((Annotation[])annotations)))) {
                Object originalFieldVal = field.get(copyObject);
                Object result = strategy.build(originalFieldVal, context);
                field.set(copyObject, result);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    private StrategyProvider getStrategy(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Strategy strategy = annotation.annotationType().getAnnotation(Strategy.class);
            if (!ObjectKit.isNotNull((Object)strategy)) continue;
            Class<? extends StrategyProvider> clazz = strategy.value();
            if (BuiltInStrategy.class.equals(clazz)) {
                return Registry.require(annotation.annotationType());
            }
            return (StrategyProvider)ClassKit.newInstance(clazz);
        }
        return null;
    }

    private ConditionProvider getCondition(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Condition condition = annotation.annotationType().getAnnotation(Condition.class);
            if (!ObjectKit.isNotNull((Object)condition)) continue;
            Class<? extends ConditionProvider> clazz = condition.value();
            return (ConditionProvider)ClassKit.newInstance(clazz);
        }
        return null;
    }

    private boolean needHandleEntryType(Class fieldTypeClass) {
        if (TypeKit.isBase((Class)fieldTypeClass) || TypeKit.isMap((Class)fieldTypeClass)) {
            return false;
        }
        return TypeKit.isJavaBean((Class)fieldTypeClass) || TypeKit.isArray((Class)fieldTypeClass) || TypeKit.isCollection((Class)fieldTypeClass);
    }
}

