/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.getter.OptNullString;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.StringUtils;

public abstract class AbsSetting
extends OptNullString<String>
implements Serializable {
    public String getStr(String key, String defaultValue) {
        return this.getStr(key, "", defaultValue);
    }

    public String getStr(String key, String group, String defaultValue) {
        String value = this.getByGroup(key, group);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public abstract String getByGroup(String var1, String var2);

    public String getWithLog(String key) {
        return this.getStr(key);
    }

    public String getByGroupWithLog(String key, String group) {
        return this.getByGroup(key, group);
    }

    public String[] getStrings(String key) {
        return this.getStrings(key, null);
    }

    public String[] getStringsWithDefault(String key, String[] defaultValue) {
        String[] value = this.getStrings(key, null);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key, String group) {
        return this.getStrings(key, group, ",");
    }

    public String[] getStrings(String key, String group, String delimiter) {
        String value = this.getByGroup(key, group);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return StringUtils.split((CharSequence)value, (CharSequence)delimiter);
    }

    public Integer getInt(String key, String group) {
        return this.getInt(key, group, null);
    }

    public Integer getInt(String key, String group, Integer defaultValue) {
        return Convert.toInt((Object)this.getByGroup(key, group), (Integer)defaultValue);
    }

    public Boolean getBool(String key, String group) {
        return this.getBool(key, group, null);
    }

    public Boolean getBool(String key, String group, Boolean defaultValue) {
        return Convert.toBool((Object)this.getByGroup(key, group), (Boolean)defaultValue);
    }

    public Long getLong(String key, String group) {
        return this.getLong(key, group, null);
    }

    public Long getLong(String key, String group, Long defaultValue) {
        return Convert.toLong((Object)this.getByGroup(key, group), (Long)defaultValue);
    }

    public Character getChar(String key, String group) {
        String value = this.getByGroup(key, group);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Double getDouble(String key, String group) {
        return this.getDouble(key, group, null);
    }

    public Double getDouble(String key, String group, Double defaultValue) {
        return Convert.toDouble((Object)this.getByGroup(key, group), (Double)defaultValue);
    }

    public Object toBean(final String group, Object bean) {
        return ClassUtils.fillBean((Object)bean, (ValueProvider)new ValueProvider<String>(){

            public Object value(String key, Type valueType) {
                String value = AbsSetting.this.getByGroup(key, group);
                return value;
            }

            public boolean containsKey(String key) {
                return null != AbsSetting.this.getByGroup(key, group);
            }
        }, (CopyOptions)CopyOptions.create());
    }

    public Object toBean(Object bean) {
        return this.toBean(null, bean);
    }
}

