/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.StringUtils;

public class GroupedMap
extends LinkedHashMap<String, LinkedHashMap<String, String>> {
    private int size = -1;

    public String get(String group, String key) {
        LinkedHashMap map = (LinkedHashMap)this.get(StringUtils.nullToEmpty((CharSequence)group));
        if (MapUtils.isNotEmpty((Map)map)) {
            return (String)map.get(key);
        }
        return null;
    }

    @Override
    public int size() {
        if (this.size < 0) {
            this.size = 0;
            for (LinkedHashMap value : this.values()) {
                this.size += value.size();
            }
        }
        return this.size;
    }

    public String put(String group, String key, String value) {
        LinkedHashMap<String, String> valueMap = (LinkedHashMap<String, String>)this.get(group = StringUtils.nullToEmpty((CharSequence)group).trim());
        if (null == valueMap) {
            valueMap = new LinkedHashMap<String, String>();
            this.put(group, valueMap);
        }
        return valueMap.put(key, value);
    }

    public GroupedMap putAll(String group, Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            this.put(group, entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String remove(String group, String key) {
        LinkedHashMap valueMap = (LinkedHashMap)this.get(group = StringUtils.nullToEmpty((CharSequence)group).trim());
        if (MapUtils.isNotEmpty((Map)valueMap)) {
            return (String)valueMap.remove(key);
        }
        return null;
    }

    public boolean isEmpty(String group) {
        LinkedHashMap valueMap = (LinkedHashMap)this.get(group = StringUtils.nullToEmpty((CharSequence)group).trim());
        if (MapUtils.isNotEmpty((Map)valueMap)) {
            return valueMap.isEmpty();
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(String group, String key) {
        LinkedHashMap valueMap = (LinkedHashMap)this.get(group = StringUtils.nullToEmpty((CharSequence)group).trim());
        if (MapUtils.isNotEmpty((Map)valueMap)) {
            return valueMap.containsKey(key);
        }
        return false;
    }

    public boolean containsValue(String group, String value) {
        LinkedHashMap valueMap = (LinkedHashMap)this.get(group = StringUtils.nullToEmpty((CharSequence)group).trim());
        if (MapUtils.isNotEmpty((Map)valueMap)) {
            return valueMap.containsValue(value);
        }
        return false;
    }

    public GroupedMap clear(String group) {
        LinkedHashMap valueMap = (LinkedHashMap)this.get(group = StringUtils.nullToEmpty((CharSequence)group).trim());
        if (MapUtils.isNotEmpty((Map)valueMap)) {
            valueMap.clear();
        }
        return this;
    }

    public Set<String> keySet(String group) {
        LinkedHashMap valueMap = (LinkedHashMap)this.get(group = StringUtils.nullToEmpty((CharSequence)group).trim());
        if (MapUtils.isNotEmpty((Map)valueMap)) {
            return valueMap.keySet();
        }
        return Collections.emptySet();
    }

    public Collection<String> values(String group) {
        LinkedHashMap valueMap = (LinkedHashMap)this.get(group = StringUtils.nullToEmpty((CharSequence)group).trim());
        if (MapUtils.isNotEmpty((Map)valueMap)) {
            return valueMap.values();
        }
        return Collections.emptyList();
    }

    public Set<Map.Entry<String, String>> entrySet(String group) {
        LinkedHashMap valueMap = (LinkedHashMap)this.get(group = StringUtils.nullToEmpty((CharSequence)group).trim());
        if (MapUtils.isNotEmpty((Map)valueMap)) {
            return valueMap.entrySet();
        }
        return Collections.emptySet();
    }
}

