/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.dialect;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.getter.BasicType;
import org.aoju.bus.core.getter.OptBasicType;
import org.aoju.bus.core.io.resource.ClassPathResource;
import org.aoju.bus.core.io.resource.FileResource;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.io.resource.UriResource;
import org.aoju.bus.core.io.watchers.SimpleWatcher;
import org.aoju.bus.core.io.watchers.WatchMonitor;
import org.aoju.bus.core.io.watchers.Watcher;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.CharsetUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.ResourceUtils;
import org.aoju.bus.core.utils.StringUtils;

public final class Props
extends Properties
implements BasicType<String>,
OptBasicType<String> {
    private static final long serialVersionUID = 1L;
    private URL propertiesFileUrl;
    private WatchMonitor watchMonitor;
    private Charset charset = org.aoju.bus.core.lang.Charset.ISO_8859_1;

    public Props() {
    }

    public Props(String path) {
        this(path, org.aoju.bus.core.lang.Charset.ISO_8859_1);
    }

    public Props(String path, String charsetName) {
        this(path, CharsetUtils.charset((String)charsetName));
    }

    public Props(String path, Charset charset) {
        Assert.notBlank((CharSequence)path, (String)"Blank properties file path !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(ResourceUtils.getResourceObj((String)path));
    }

    public Props(File propertiesFile) {
        this(propertiesFile, StandardCharsets.ISO_8859_1);
    }

    public Props(File propertiesFile, String charsetName) {
        this(propertiesFile, Charset.forName(charsetName));
    }

    public Props(File propertiesFile, Charset charset) {
        Assert.notNull((Object)propertiesFile, (String)"Null properties file!", (Object[])new Object[0]);
        this.charset = charset;
        this.load((Resource)new FileResource(propertiesFile));
    }

    public Props(String path, Class<?> clazz) {
        this(path, clazz, org.aoju.bus.core.lang.Charset.ISO_8859_1);
    }

    public Props(String path, Class<?> clazz, String charsetName) {
        this(path, clazz, CharsetUtils.charset((String)charsetName));
    }

    public Props(String path, Class<?> clazz, Charset charset) {
        Assert.notBlank((CharSequence)path, (String)"Blank properties file path !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load((Resource)new ClassPathResource(path, clazz));
    }

    public Props(URL propertiesUrl) {
        this(propertiesUrl, StandardCharsets.ISO_8859_1);
    }

    public Props(URL propertiesUrl, String charsetName) {
        this(propertiesUrl, CharsetUtils.charset((String)charsetName));
    }

    public Props(URL propertiesUrl, Charset charset) {
        Assert.notNull((Object)propertiesUrl, (String)"Null properties URL !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load((Resource)new UriResource(propertiesUrl));
    }

    public Props(Properties properties) {
        if (CollUtils.isNotEmpty((Map)properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public static Properties getProp(String resource) {
        return new Props(resource);
    }

    public static Properties getProp(String resource, String charsetName) {
        return new Props(resource, charsetName);
    }

    public static Properties getProp(String resource, Charset charset) {
        return new Props(resource, charset);
    }

    public void load(Resource urlResource) {
        this.propertiesFileUrl = urlResource.getUrl();
        if (null == this.propertiesFileUrl) {
            throw new InstrumentException("Can not find properties file: [{}]", new Object[]{urlResource});
        }
        try (BufferedReader reader = urlResource.getReader(this.charset);){
            super.load(reader);
        }
        catch (Exception e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public void load() {
        this.load((Resource)new UriResource(this.propertiesFileUrl));
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            try {
                this.watchMonitor = WatchMonitor.create((Path)Paths.get(this.propertiesFileUrl.toURI()), (WatchEvent.Kind[])new WatchEvent.Kind[0]);
                this.watchMonitor.setWatcher((Watcher)new SimpleWatcher(){

                    public void onModify(WatchEvent<?> event, Path currentPath) {
                        Props.this.load();
                    }
                }).start();
            }
            catch (Exception e) {
                throw new InstrumentException("Setting auto load not support url: [{}]", new Object[]{this.propertiesFileUrl});
            }
        } else {
            IoUtils.close((Closeable)this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    public Object getObj(String key, Object defaultValue) {
        return this.getStr(key, null == defaultValue ? null : defaultValue.toString());
    }

    public Object getObj(String key) {
        return this.getObj(key, null);
    }

    public String getStr(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    public String getStr(String key) {
        return super.getProperty(key);
    }

    public Integer getInt(String key, Integer defaultValue) {
        return Convert.toInt((Object)this.getStr(key), (Integer)defaultValue);
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Boolean getBool(String key, Boolean defaultValue) {
        return Convert.toBool((Object)this.getStr(key), (Boolean)defaultValue);
    }

    public Boolean getBool(String key) {
        return this.getBool(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        return Convert.toLong((Object)this.getStr(key), (Long)defaultValue);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Character getChar(String key, Character defaultValue) {
        String value = this.getStr(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Character getChar(String key) {
        return this.getChar(key, null);
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Float getFloat(String key, Float defaultValue) {
        return Convert.toFloat((Object)this.getStr(key), (Float)defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) throws NumberFormatException {
        return Convert.toDouble((Object)this.getStr(key), (Double)defaultValue);
    }

    public Double getDouble(String key) throws NumberFormatException {
        return this.getDouble(key, null);
    }

    public Short getShort(String key, Short defaultValue) {
        return Convert.toShort((Object)this.getStr(key), (Short)defaultValue);
    }

    public Short getShort(String key) {
        return this.getShort(key, null);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return Convert.toByte((Object)this.getStr(key), (Byte)defaultValue);
    }

    public Byte getByte(String key) {
        return this.getByte(key, null);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String valueStr = this.getStr(key);
        if (StringUtils.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, null);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        String valueStr = this.getStr(key);
        if (StringUtils.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public BigInteger getBigInteger(String key) {
        return this.getBigInteger(key, null);
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key, E defaultValue) {
        return (E)Convert.toEnum(clazz, (Object)this.getStr(key), defaultValue);
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return this.getEnum(clazz, key, null);
    }

    public Date getDate(String key, Date defaultValue) {
        return Convert.toDate((Object)this.getStr(key), (Date)defaultValue);
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public String getAndRemoveStr(String ... keys) {
        String key;
        Object value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return (String)value;
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public void store(String absolutePath) throws InstrumentException {
        BufferedWriter writer = null;
        try {
            writer = FileUtils.getWriter((String)absolutePath, (Charset)this.charset, (boolean)false);
            super.store(writer, null);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException("Store properties to [{}] error!", absolutePath);
            }
            catch (Throwable throwable) {
                IoUtils.close(writer);
                throw throwable;
            }
        }
        IoUtils.close((Closeable)writer);
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileUtils.getAbsolutePath((String)path, clazz));
    }
}

