/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.io.resource.ClassPathResource;
import org.aoju.bus.core.io.resource.FileResource;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.io.resource.UriResource;
import org.aoju.bus.core.io.watchers.SimpleWatcher;
import org.aoju.bus.core.io.watchers.WatchMonitor;
import org.aoju.bus.core.io.watchers.Watcher;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.ResourceUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.setting.AbsSetting;
import org.aoju.bus.setting.GroupedMap;
import org.aoju.bus.setting.SettingLoader;
import org.aoju.bus.setting.dialect.Props;

public class Setting
extends AbsSetting
implements Map<String, String> {
    private final GroupedMap groupedMap = new GroupedMap();
    protected java.nio.charset.Charset charset;
    protected boolean isUseVariable;
    protected URL settingUrl;
    private SettingLoader settingLoader;
    private WatchMonitor watchMonitor;

    public Setting() {
    }

    public Setting(String path) {
        this(path, false);
    }

    public Setting(String path, boolean isUseVariable) {
        this(path, Charset.UTF_8, isUseVariable);
    }

    public Setting(String path, java.nio.charset.Charset charset, boolean isUseVariable) {
        Assert.notBlank((CharSequence)path, (String)"Blank setting path !", (Object[])new Object[0]);
        this.init(ResourceUtils.getResourceObj((String)path), charset, isUseVariable);
    }

    public Setting(File configFile, java.nio.charset.Charset charset, boolean isUseVariable) {
        Assert.notNull((Object)configFile, (String)"Null setting file define!", (Object[])new Object[0]);
        this.init((Resource)new FileResource(configFile), charset, isUseVariable);
    }

    public Setting(String path, Class<?> clazz, java.nio.charset.Charset charset, boolean isUseVariable) {
        Assert.notBlank((CharSequence)path, (String)"Blank setting path !", (Object[])new Object[0]);
        this.init((Resource)new ClassPathResource(path, clazz), charset, isUseVariable);
    }

    public Setting(URL url, java.nio.charset.Charset charset, boolean isUseVariable) {
        Assert.notNull((Object)url, (String)"Null setting url define!", (Object[])new Object[0]);
        this.init((Resource)new UriResource(url), charset, isUseVariable);
    }

    public boolean init(Resource resource, java.nio.charset.Charset charset, boolean isUseVariable) {
        if (resource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        this.settingUrl = resource.getUrl();
        this.charset = charset;
        this.isUseVariable = isUseVariable;
        return this.load();
    }

    public synchronized boolean load() {
        if (null == this.settingLoader) {
            this.settingLoader = new SettingLoader(this.groupedMap, this.charset, this.isUseVariable);
        }
        return this.settingLoader.load(new UriResource(this.settingUrl));
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            try {
                this.watchMonitor = WatchMonitor.create((URL)this.settingUrl, (WatchEvent.Kind[])new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY});
                this.watchMonitor.setWatcher((Watcher)new SimpleWatcher(){

                    public void onModify(WatchEvent<?> event, Path currentPath) {
                        Setting.this.load();
                    }
                }).start();
            }
            catch (Exception e) {
                throw new InstrumentException("Setting auto load not support url: [{}]", new Object[]{this.settingUrl});
            }
        } else {
            this.watchMonitor = null;
        }
    }

    public String getSettingPath() {
        return null == this.settingUrl ? null : this.settingUrl.getPath();
    }

    @Override
    public int size() {
        return this.groupedMap.size();
    }

    @Override
    public String getByGroup(String key, String group) {
        return this.groupedMap.get(group, key);
    }

    public Object getAndRemove(String ... keys) {
        String key;
        String value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return value;
    }

    public String getAndRemoveStr(String ... keys) {
        String key;
        String value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return value;
    }

    public Map<String, String> getMap(String group) {
        return (Map)this.groupedMap.get(group);
    }

    public Setting getSetting(String group) {
        Setting setting = new Setting();
        setting.putAll((Map<? extends String, ? extends String>)this.getMap(group));
        return setting;
    }

    public Properties getProperties(String group) {
        Properties properties = new Properties();
        properties.putAll(this.getMap(group));
        return properties;
    }

    public Props getProps(String group) {
        Props props = new Props();
        props.putAll(this.getMap(group));
        return props;
    }

    public void store(String absolutePath) {
        if (null == this.settingLoader) {
            this.settingLoader = new SettingLoader(this.groupedMap, this.charset, this.isUseVariable);
        }
        this.settingLoader.store(absolutePath);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        for (Map.Entry groupEntry : this.groupedMap.entrySet()) {
            String group = (String)groupEntry.getKey();
            for (Map.Entry entry : ((LinkedHashMap)groupEntry.getValue()).entrySet()) {
                properties.setProperty(StringUtils.isEmpty((CharSequence)group) ? (String)entry.getKey() : group + "." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        return properties;
    }

    public GroupedMap getGroupedMap() {
        return this.groupedMap;
    }

    public List<String> getGroups() {
        return CollUtils.newArrayList(this.groupedMap.keySet());
    }

    public void setVarRegex(String regex) {
        if (null == this.settingLoader) {
            throw new NullPointerException("SettingLoader is null !");
        }
        this.settingLoader.setVarRegex(regex);
    }

    public boolean isEmpty(String group) {
        return this.groupedMap.isEmpty(group);
    }

    public boolean containsKey(String group, String key) {
        return this.groupedMap.containsKey(group, key);
    }

    public boolean containsValue(String group, String value) {
        return this.groupedMap.containsValue(group, value);
    }

    public String get(String group, String key) {
        return this.groupedMap.get(group, key);
    }

    public String put(String group, String key, String value) {
        return this.groupedMap.put(group, key, value);
    }

    public String remove(String group, Object key) {
        return this.groupedMap.remove(group, Convert.toString((Object)key));
    }

    public Setting putAll(String group, Map<? extends String, ? extends String> m) {
        this.groupedMap.putAll(group, m);
        return this;
    }

    public Setting clear(String group) {
        this.groupedMap.clear(group);
        return this;
    }

    public Set<String> keySet(String group) {
        return this.groupedMap.keySet(group);
    }

    public Collection<String> values(String group) {
        return this.groupedMap.values(group);
    }

    public Set<Map.Entry<String, String>> entrySet(String group) {
        return this.groupedMap.entrySet(group);
    }

    public Setting set(String key, String value) {
        this.groupedMap.put("", key, value);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.groupedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.groupedMap.containsKey("", Convert.toString((Object)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.groupedMap.containsValue("", Convert.toString((Object)value));
    }

    @Override
    public String get(Object key) {
        return this.groupedMap.get("", Convert.toString((Object)key));
    }

    @Override
    public String put(String key, String value) {
        return this.groupedMap.put("", key, value);
    }

    @Override
    public String remove(Object key) {
        return this.groupedMap.remove("", Convert.toString((Object)key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.groupedMap.putAll("", m);
    }

    @Override
    public void clear() {
        this.groupedMap.clear("");
    }

    @Override
    public Set<String> keySet() {
        return this.groupedMap.keySet("");
    }

    @Override
    public Collection<String> values() {
        return this.groupedMap.values("");
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.groupedMap.entrySet("");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.groupedMap == null ? 0 : this.groupedMap.hashCode());
        result = 31 * result + (this.isUseVariable ? 1231 : 1237);
        result = 31 * result + (this.settingUrl == null ? 0 : this.settingUrl.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Setting other = (Setting)obj;
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        if (this.groupedMap == null ? other.groupedMap != null : !this.groupedMap.equals(other.groupedMap)) {
            return false;
        }
        if (this.isUseVariable != other.isUseVariable) {
            return false;
        }
        return !(this.settingUrl == null ? other.settingUrl != null : !this.settingUrl.equals(other.settingUrl));
    }

    public String toString() {
        return this.groupedMap.toString();
    }
}

