/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.io.resource.UriResource;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.setting.GroupedMap;

public class SettingLoader {
    private static final char COMMENT_FLAG_PRE = '#';
    private static final char ASSIGN_FLAG = '=';
    private String reg_var = "\\$\\{(.*?)\\}";
    private java.nio.charset.Charset charset;
    private boolean isUseVariable;
    private GroupedMap groupedMap;

    public SettingLoader(GroupedMap groupedMap) {
        this(groupedMap, Charset.UTF_8, false);
    }

    public SettingLoader(GroupedMap groupedMap, java.nio.charset.Charset charset, boolean isUseVariable) {
        this.groupedMap = groupedMap;
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    public boolean load(UriResource uriResource) {
        if (uriResource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        try {
            InputStream settingStream = uriResource.getStream();
            this.load(settingStream);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream settingStream) throws IOException {
        this.groupedMap.clear();
        BufferedReader reader = null;
        try {
            String line;
            reader = IoKit.getReader((InputStream)settingStream, (java.nio.charset.Charset)this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (StringKit.isBlank((CharSequence)(line = line.trim())) || StringKit.startWith((CharSequence)line, (char)'#')) continue;
                if (StringKit.isSurround((CharSequence)line, (CharSequence)"[", (CharSequence)"]")) {
                    group = line.substring(1, line.length() - 1).trim();
                    continue;
                }
                String[] keyValue = StringKit.splitToArray((CharSequence)line, (char)'=', (int)2);
                if (keyValue.length < 2) continue;
                String value = keyValue[1].trim();
                if (this.isUseVariable) {
                    value = this.replaceVar(group, value);
                }
                this.groupedMap.put(group, keyValue[0].trim(), value);
            }
        }
        catch (Throwable throwable) {
            IoKit.close(reader);
            throw throwable;
        }
        IoKit.close((Closeable)reader);
        return true;
    }

    public void setVarRegex(String regex) {
        this.reg_var = regex;
    }

    public void store(String absolutePath) {
        PrintWriter writer = null;
        try {
            writer = FileKit.getPrintWriter((String)absolutePath, (java.nio.charset.Charset)this.charset, (boolean)false);
            this.store(writer);
        }
        catch (Throwable throwable) {
            IoKit.close(writer);
            throw throwable;
        }
        IoKit.close((Closeable)writer);
    }

    private void store(PrintWriter writer) {
        for (Map.Entry groupEntry : this.groupedMap.entrySet()) {
            writer.println(StringKit.format((String)"{}{}{}", (Object[])new Object[]{"[", groupEntry.getKey(), "]"}));
            for (Map.Entry entry : ((LinkedHashMap)groupEntry.getValue()).entrySet()) {
                writer.println(StringKit.format((String)"{} {} {}", (Object[])new Object[]{entry.getKey(), Character.valueOf('='), entry.getValue()}));
            }
        }
    }

    private String replaceVar(String group, String value) {
        Set vars = (Set)PatternKit.findAll((String)this.reg_var, (String)value, (int)0, new HashSet());
        for (String var : vars) {
            String key = PatternKit.get((String)this.reg_var, (String)var, (int)1);
            if (!StringKit.isNotBlank((CharSequence)key)) continue;
            String varValue = this.groupedMap.get(group, key);
            if (null != varValue) {
                value = value.replace(var, varValue);
                continue;
            }
            List groupAndKey = StringKit.split((CharSequence)key, (char)'.', (int)2);
            if (groupAndKey.size() <= 1 || null == (varValue = this.groupedMap.get((String)groupAndKey.get(0), (String)groupAndKey.get(1)))) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }
}

