/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2020 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 ********************************************************************************/
package org.aoju.bus.setting.magic;

import java.util.Map;

/**
 * Ini file's parameters, like {@code property1=value1 }
 *
 * @author Kimi Liu
 * @version 6.0.8
 * @since JDK 1.8+
 */
public interface IniProperty extends Map.Entry<String, String>, IniElement {

    /**
     * section getter.
     *
     * @return from section
     */
    IniSection getSection();

    /**
     * section setter.
     *
     * @param section from section
     */
    void setSection(IniSection section);

    /**
     * get key value
     *
     * @return String field: key
     */
    String key();

    /**
     * change key value.
     *
     * @param newKey new key.
     */
    void changeKey(String newKey);

    /**
     * set a new Key.
     *
     * @param newKey new Key
     * @return old value.
     */
    String setKey(String newKey);

    /**
     * get key
     *
     * @return key
     * @see #key()
     */
    @Override
    default String getKey() {
        return key();
    }

    /**
     * get value
     *
     * @return value
     * @see #value()
     */
    @Override
    default String getValue() {
        return value();
    }

}
