/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.magic;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Date;
import java.util.Map;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.getter.BasicType;
import org.aoju.bus.core.getter.OptBasicType;
import org.aoju.bus.core.io.resource.ClassPathResource;
import org.aoju.bus.core.io.resource.FileResource;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.io.resource.UriResource;
import org.aoju.bus.core.io.watchers.SimpleWatcher;
import org.aoju.bus.core.io.watchers.WatchMonitor;
import org.aoju.bus.core.io.watchers.Watcher;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.WatchKit;
import org.aoju.bus.logger.Logger;

public final class Properties
extends java.util.Properties
implements BasicType<String>,
OptBasicType<String> {
    private static final long serialVersionUID = 1L;
    private URL propertiesFileUrl;
    private WatchMonitor watchMonitor;
    private Charset charset = org.aoju.bus.core.lang.Charset.ISO_8859_1;

    public Properties() {
    }

    public Properties(String path) {
        this(path, org.aoju.bus.core.lang.Charset.ISO_8859_1);
    }

    public Properties(String path, String charsetName) {
        this(path, org.aoju.bus.core.lang.Charset.charset((String)charsetName));
    }

    public Properties(String path, Charset charset) {
        Assert.notBlank((CharSequence)path, (String)"Blank properties file path !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(FileKit.getResourceObj((String)path));
    }

    public Properties(File propertiesFile) {
        this(propertiesFile, org.aoju.bus.core.lang.Charset.ISO_8859_1);
    }

    public Properties(File propertiesFile, String charsetName) {
        this(propertiesFile, Charset.forName(charsetName));
    }

    public Properties(File propertiesFile, Charset charset) {
        Assert.notNull((Object)propertiesFile, (String)"Null properties file!", (Object[])new Object[0]);
        this.charset = charset;
        this.load((Resource)new FileResource(propertiesFile));
    }

    public Properties(String path, Class<?> clazz) {
        this(path, clazz, org.aoju.bus.core.lang.Charset.ISO_8859_1);
    }

    public Properties(String path, Class<?> clazz, String charsetName) {
        this(path, clazz, org.aoju.bus.core.lang.Charset.charset((String)charsetName));
    }

    public Properties(String path, Class<?> clazz, Charset charset) {
        Assert.notBlank((CharSequence)path, (String)"Blank properties file path !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load((Resource)new ClassPathResource(path, clazz));
    }

    public Properties(URL propertiesUrl) {
        this(propertiesUrl, org.aoju.bus.core.lang.Charset.ISO_8859_1);
    }

    public Properties(URL propertiesUrl, String charsetName) {
        this(propertiesUrl, org.aoju.bus.core.lang.Charset.charset((String)charsetName));
    }

    public Properties(URL propertiesUrl, Charset charset) {
        Assert.notNull((Object)propertiesUrl, (String)"Null properties URL !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load((Resource)new UriResource(propertiesUrl));
    }

    public Properties(java.util.Properties properties) {
        if (CollKit.isNotEmpty((Map)properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public static java.util.Properties getProp(String resource) {
        return new Properties(resource);
    }

    public static java.util.Properties getProp(String resource, String charsetName) {
        return new Properties(resource, charsetName);
    }

    public static java.util.Properties getProp(String resource, Charset charset) {
        return new Properties(resource, charset);
    }

    public static java.util.Properties getProp(String resource, Class<?> clazz) {
        return new Properties(resource, clazz);
    }

    public void load(URL url) {
        this.load((Resource)new UriResource(url));
    }

    public void load(Resource resource) {
        this.propertiesFileUrl = resource.getUrl();
        if (null == this.propertiesFileUrl) {
            throw new InstrumentException("Can not find properties file: [{}]", new Object[]{resource});
        }
        try (BufferedReader reader = resource.getReader(this.charset);){
            super.load(reader);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public void load() {
        this.load(this.propertiesFileUrl);
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            Assert.notNull((Object)this.propertiesFileUrl, (String)"Properties URL is null !", (Object[])new Object[0]);
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchKit.createModify((URL)this.propertiesFileUrl, (Watcher)new SimpleWatcher(){

                public void onModify(WatchEvent<?> event, Path currentPath) {
                    Properties.this.load();
                }
            });
            this.watchMonitor.start();
        } else {
            IoKit.close((Closeable)this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    public Object getObj(String key, Object defaultValue) {
        return this.getStr(key, null == defaultValue ? null : defaultValue.toString());
    }

    public Object getObj(String key) {
        return this.getObj(key, null);
    }

    public String getStr(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    public String getStr(String key) {
        return super.getProperty(key);
    }

    public Integer getInt(String key, Integer defaultValue) {
        return Convert.toInt((Object)this.getStr(key), (Integer)defaultValue);
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Boolean getBool(String key, Boolean defaultValue) {
        return Convert.toBool((Object)this.getStr(key), (Boolean)defaultValue);
    }

    public Boolean getBool(String key) {
        return this.getBool(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        return Convert.toLong((Object)this.getStr(key), (Long)defaultValue);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Character getChar(String key, Character defaultValue) {
        String value = this.getStr(key);
        if (StringKit.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Character getChar(String key) {
        return this.getChar(key, null);
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Float getFloat(String key, Float defaultValue) {
        return Convert.toFloat((Object)this.getStr(key), (Float)defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) throws NumberFormatException {
        return Convert.toDouble((Object)this.getStr(key), (Double)defaultValue);
    }

    public Double getDouble(String key) throws NumberFormatException {
        return this.getDouble(key, null);
    }

    public Short getShort(String key, Short defaultValue) {
        return Convert.toShort((Object)this.getStr(key), (Short)defaultValue);
    }

    public Short getShort(String key) {
        return this.getShort(key, null);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return Convert.toByte((Object)this.getStr(key), (Byte)defaultValue);
    }

    public Byte getByte(String key) {
        return this.getByte(key, null);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String valueStr = this.getStr(key);
        if (StringKit.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, null);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        String valueStr = this.getStr(key);
        if (StringKit.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public BigInteger getBigInteger(String key) {
        return this.getBigInteger(key, null);
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key, E defaultValue) {
        return (E)Convert.toEnum(clazz, (Object)this.getStr(key), defaultValue);
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return this.getEnum(clazz, key, null);
    }

    public Date getDate(String key, Date defaultValue) {
        return Convert.toDate((Object)this.getStr(key), (Date)defaultValue);
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public String getAndRemoveStr(String ... keys) {
        String key;
        Object value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return (String)value;
    }

    public <T> T toBean(Class<T> beanClass) {
        return this.toBean(beanClass, null);
    }

    public <T> T toBean(Class<T> beanClass, String prefix) {
        Object bean = ReflectKit.newInstanceIfPossible(beanClass);
        return (T)this.fillBean(bean, prefix);
    }

    public <T> T fillBean(T bean, String prefix) {
        prefix = StringKit.nullToEmpty((CharSequence)StringKit.addSuffixIfNot((CharSequence)prefix, (CharSequence)"."));
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!StringKit.startWith((CharSequence)key, (CharSequence)prefix)) continue;
            try {
                BeanKit.setProperty(bean, (String)StringKit.subSuf((CharSequence)key, (int)prefix.length()), (Object)entry.getValue());
            }
            catch (Exception e) {
                Logger.debug((String)"Ignore property: [{}]", (Object[])new Object[]{key});
            }
        }
        return bean;
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public void store(String absolutePath) throws InstrumentException {
        BufferedWriter writer = null;
        try {
            writer = FileKit.getWriter((String)absolutePath, (Charset)this.charset, (boolean)false);
            super.store(writer, null);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException("Store properties to [{}] error!", absolutePath);
            }
            catch (Throwable throwable) {
                IoKit.close(writer);
                throw throwable;
            }
        }
        IoKit.close((Closeable)writer);
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileKit.getAbsolutePath((String)path, clazz));
    }
}

