/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.metric;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.setting.magic.PopSetting;

public class Profile
implements Serializable {
    public static final String DEFAULT_PROFILE = "default";
    private static final long serialVersionUID = 1L;
    private String profile;
    private Charset charset;
    private boolean useVar;
    private Map<String, PopSetting> settingMap = new ConcurrentHashMap<String, PopSetting>();

    public Profile() {
        this(DEFAULT_PROFILE);
    }

    public Profile(String profile) {
        this(profile, org.aoju.bus.core.lang.Charset.UTF_8, false);
    }

    public Profile(String profile, Charset charset, boolean useVar) {
        this.profile = profile;
        this.charset = charset;
        this.useVar = useVar;
    }

    public PopSetting getSetting(String name) {
        String nameForProfile = this.fixNameForProfile(name);
        PopSetting popSetting = this.settingMap.get(nameForProfile);
        if (null == popSetting) {
            popSetting = new PopSetting(nameForProfile, this.charset, this.useVar);
            this.settingMap.put(nameForProfile, popSetting);
        }
        return popSetting;
    }

    public Profile setProfile(String profile) {
        this.profile = profile;
        return this;
    }

    public Profile setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Profile setUseVar(boolean useVar) {
        this.useVar = useVar;
        return this;
    }

    public Profile clear() {
        this.settingMap.clear();
        return this;
    }

    private String fixNameForProfile(String name) {
        String actralProfile;
        String string = actralProfile = null == this.profile ? "" : this.profile;
        if (StringKit.isNotBlank((CharSequence)name) && !name.contains(".")) {
            return StringKit.format((String)"{}/{}.setting", (Object[])new Object[]{actralProfile, name});
        }
        return StringKit.format((String)"{}/{}", (Object[])new Object[]{actralProfile});
    }
}

