/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.format;

import java.util.Objects;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.setting.Format;
import org.aoju.bus.setting.format.ElementFormatter;
import org.aoju.bus.setting.magic.IniComment;
import org.aoju.bus.setting.magic.IniElement;
import org.aoju.bus.setting.magic.IniProperty;
import org.aoju.bus.setting.magic.IniSection;

public class DefaultFormatter
implements Format {
    protected final ElementFormatter<IniComment> commentElementFormatter;
    protected final ElementFormatter<IniSection> sectionElementFormatter;
    protected final ElementFormatter<IniProperty> propertyElementFormatter;
    protected IniSection lastSection;
    private int lineNumber = 0;
    private int effectiveLineNumber = 0;

    public DefaultFormatter(ElementFormatter<IniComment> commentElementFormatter, ElementFormatter<IniSection> sectionElementFormatter, ElementFormatter<IniProperty> propertyElementFormatter) {
        this.commentElementFormatter = commentElementFormatter;
        this.sectionElementFormatter = sectionElementFormatter;
        this.propertyElementFormatter = propertyElementFormatter;
    }

    @Override
    public IniElement formatLine(String raw) {
        IniElement element;
        Objects.requireNonNull(raw);
        ++this.lineNumber;
        String line = raw.trim();
        if (line.length() == 0) {
            return null;
        }
        int preEffectiveLineNumber = this.effectiveLineNumber + 1;
        if (this.commentElementFormatter.check(line)) {
            element = this.commentElementFormatter.format(line, preEffectiveLineNumber);
        } else if (this.sectionElementFormatter.check(line)) {
            IniSection section;
            this.lastSection = section = this.sectionElementFormatter.format(line, preEffectiveLineNumber);
            element = section;
        } else if (this.propertyElementFormatter.check(line)) {
            IniProperty property = this.propertyElementFormatter.format(line, preEffectiveLineNumber);
            if (this.lastSection == null) {
                throw new InstrumentException("Cannot found section for property line " + this.lineNumber + " : " + line);
            }
            property.setSection(this.lastSection);
            this.lastSection.add(property);
            element = property;
        } else {
            throw new InstrumentException("No matching element type found for line " + this.lineNumber + " : " + line);
        }
        this.effectiveLineNumber = preEffectiveLineNumber;
        return element;
    }

    @Override
    public synchronized void init() {
        this.lineNumber = 0;
        this.effectiveLineNumber = 0;
        this.lastSection = null;
    }
}

