/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.setting.magic.IniComment;
import org.aoju.bus.setting.magic.IniCommentImpl;
import org.aoju.bus.setting.magic.IniElement;
import org.aoju.bus.setting.magic.IniProperty;
import org.aoju.bus.setting.magic.IniPropertyImpl;
import org.aoju.bus.setting.magic.IniSection;
import org.aoju.bus.setting.magic.IniSectionImpl;
import org.aoju.bus.setting.magic.IniSetting;
import org.aoju.bus.setting.magic.PopSetting;
import org.aoju.bus.setting.magic.Properties;

public class Builder {
    private static final Map<String, Properties> CACHE_PROPS = new ConcurrentHashMap<String, Properties>();
    private static final Map<String, PopSetting> CACHE_SETTING = new ConcurrentHashMap<String, PopSetting>();
    private List<IniElement> elements;
    private LinkedList<Supplier<IniProperty>> waitForSections = new LinkedList();
    private IniSection lastSection;
    private int line = 1;
    private IniSectionCreator iniSectionCreator = IniSectionCreator.DEFAULT;
    private IniCommentCreator iniCommentCreator = IniCommentCreator.DEFAULT;
    private IniPropertyCreator iniPropertyCreator = IniPropertyCreator.DEFAULT;

    public Builder() {
        this.elements = new ArrayList<IniElement>();
    }

    public Builder(Supplier<List<IniElement>> listSupplier) {
        this.elements = listSupplier.get();
    }

    public static Properties getProperties(String name) {
        return CACHE_PROPS.computeIfAbsent(name, filePath -> {
            String extName = FileKit.extName((String)filePath);
            if (StringKit.isEmpty((CharSequence)extName)) {
                filePath = filePath + ".properties";
            }
            return new Properties((String)filePath);
        });
    }

    public Builder sectionCreator(IniSectionCreator iniSectionCreator) {
        Objects.requireNonNull(iniSectionCreator);
        this.iniSectionCreator = iniSectionCreator;
        return this;
    }

    public Builder commentCreator(IniCommentCreator iniCommentCreator) {
        Objects.requireNonNull(iniCommentCreator);
        this.iniCommentCreator = iniCommentCreator;
        return this;
    }

    public Builder propertyCreator(IniPropertyCreator iniPropertyCreator) {
        Objects.requireNonNull(iniPropertyCreator);
        this.iniPropertyCreator = iniPropertyCreator;
        return this;
    }

    public Builder skipLine(int length) {
        for (int i = 0; i < length; ++i) {
            this.elements.add(null);
            ++this.line;
        }
        return this;
    }

    public Builder plus(Builder otherBuilder) {
        this.elements.addAll(otherBuilder.elements);
        this.line += otherBuilder.line - 1;
        return this;
    }

    public Builder plus(List<IniElement> elements) {
        this.elements.addAll(elements);
        this.line += elements.size();
        return this;
    }

    public Builder plusSection(String value) {
        IniSection section = this.iniSectionCreator.create(value, this.line++, null);
        this.elements.add(section);
        this.lastSection = section;
        this.checkProps();
        return this;
    }

    public Builder plusSection(String value, IniComment comment) {
        IniSection section = this.iniSectionCreator.create(value, this.line++, comment);
        this.elements.add(section);
        this.lastSection = section;
        this.checkProps();
        return this;
    }

    public Builder plusSection(String value, String commentValue) {
        int lineNumber = this.line++;
        IniComment comment = this.iniCommentCreator.create(commentValue, lineNumber);
        IniSection section = this.iniSectionCreator.create(value, lineNumber, comment);
        this.elements.add(section);
        this.lastSection = section;
        this.checkProps();
        return this;
    }

    private void checkProps() {
        if (this.lastSection != null && !this.waitForSections.isEmpty()) {
            while (!this.waitForSections.isEmpty()) {
                IniProperty property = this.waitForSections.removeLast().get();
                property.setSection(this.lastSection);
                this.lastSection.add(property);
                this.elements.add(property);
            }
        }
    }

    private void checkProps(Supplier<IniProperty> propertySupplier) {
        if (this.lastSection == null) {
            this.waitForSections.addFirst(propertySupplier);
        } else {
            this.checkProps();
            IniProperty property = propertySupplier.get();
            property.setSection(this.lastSection);
            this.lastSection.add(property);
            this.elements.add(property);
        }
    }

    public Builder plusProperty(String key, String value) {
        this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, null));
        return this;
    }

    public Builder plusProperty(String key, String value, IniComment comment) {
        this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, comment));
        return this;
    }

    public Builder plusProperty(String key, String value, String commentValue) {
        this.checkProps(() -> {
            int lineNumber = this.line++;
            IniComment comment = this.iniCommentCreator.create(commentValue, lineNumber);
            return this.iniPropertyCreator.create(key, value, lineNumber, comment);
        });
        return this;
    }

    public Builder plusProperties(java.util.Properties properties) {
        Set<String> names = properties.stringPropertyNames();
        for (String key : names) {
            String value = properties.getProperty(key);
            this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, null));
        }
        return this;
    }

    public Builder plusProperties(java.util.Properties properties, IniComment comment) {
        Set<String> names = properties.stringPropertyNames();
        for (String key : names) {
            String value = properties.getProperty(key);
            this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, comment));
        }
        return this;
    }

    public Builder plusProperties(java.util.Properties properties, String commentValue) {
        Set<String> names = properties.stringPropertyNames();
        for (String key : names) {
            String value = properties.getProperty(key);
            this.checkProps(() -> {
                int lineNumber = this.line++;
                IniComment comment = this.iniCommentCreator.create(commentValue, lineNumber);
                return this.iniPropertyCreator.create(key, value, lineNumber, comment);
            });
        }
        return this;
    }

    public Builder plusComment(String value) {
        IniComment comment = this.iniCommentCreator.create(value, this.line++);
        this.elements.add(comment);
        return this;
    }

    public IniSetting build() {
        return new IniSetting((Collection<? extends IniElement>)this.elements);
    }

    @FunctionalInterface
    public static interface IniPropertyCreator {
        public static final IniPropertyCreator DEFAULT = (k, v, l, c) -> new IniPropertyImpl(k, v, l);

        public IniProperty create(String var1, String var2, int var3, IniComment var4);
    }

    @FunctionalInterface
    public static interface IniCommentCreator {
        public static final IniCommentCreator DEFAULT = IniCommentImpl::byValue;

        public IniComment create(String var1, int var2);
    }

    @FunctionalInterface
    public static interface IniSectionCreator {
        public static final IniSectionCreator DEFAULT = IniSectionImpl::new;

        public IniSection create(String var1, int var2, IniComment var3);
    }
}

