/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.magic;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.aoju.bus.setting.magic.AbstractElement;
import org.aoju.bus.setting.magic.IniComment;
import org.aoju.bus.setting.magic.IniProperty;
import org.aoju.bus.setting.magic.IniSection;

public class IniSectionImpl
extends AbstractElement
implements IniSection {
    private List<IniProperty> properties;

    public IniSectionImpl(String value, int lineNumber) {
        super(value, '[' + value + ']', lineNumber);
        this.properties = new ArrayList<IniProperty>();
    }

    public IniSectionImpl(String value, String originalValue, int lineNumber) {
        super(value, originalValue, lineNumber);
        this.properties = new ArrayList<IniProperty>();
    }

    public IniSectionImpl(String value, String originalValue, int lineNumber, Supplier<List<IniProperty>> listSupplier) {
        super(value, originalValue, lineNumber);
        this.properties = listSupplier.get();
    }

    public IniSectionImpl(String value, int lineNumber, IniComment comment) {
        super(value, '[' + value + ']', lineNumber, comment);
        this.properties = new ArrayList<IniProperty>();
    }

    public IniSectionImpl(String value, String originalValue, int lineNumber, IniComment comment) {
        super(value, originalValue, lineNumber, comment);
        this.properties = new ArrayList<IniProperty>();
    }

    public IniSectionImpl(String value, String originalValue, int lineNumber, IniComment comment, Supplier<List<IniProperty>> listSupplier) {
        super(value, originalValue, lineNumber, comment);
        this.properties = listSupplier.get();
    }

    @Override
    protected String valueChanged(String newValue) {
        return "[" + newValue + "]";
    }

    @Override
    public String toPropertiesString() {
        StringJoiner joiner = new StringJoiner(System.getProperty("line.separator", "\n"));
        joiner.add(this.toString());
        for (IniProperty p : this) {
            joiner.add(p);
        }
        return joiner.toString();
    }

    @Override
    public List<IniProperty> getList() {
        return new ArrayList<IniProperty>(this.properties);
    }

    @Override
    public List<IniProperty> getList(Supplier<List<IniProperty>> listSupplier) {
        List<IniProperty> list = listSupplier.get();
        list.addAll(this.properties);
        return list;
    }

    @Override
    public List<IniProperty> getProxyList() {
        return this.properties;
    }
}

