/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.setting.Factory;
import org.aoju.bus.setting.Format;
import org.aoju.bus.setting.format.CommentFormatter;
import org.aoju.bus.setting.format.DefaultFormatter;
import org.aoju.bus.setting.format.ElementFormatter;
import org.aoju.bus.setting.format.PropertyFormatter;
import org.aoju.bus.setting.format.SectionFormatter;
import org.aoju.bus.setting.magic.IniComment;
import org.aoju.bus.setting.magic.IniElement;
import org.aoju.bus.setting.magic.IniProperty;
import org.aoju.bus.setting.magic.IniSection;
import org.aoju.bus.setting.magic.IniSetting;
import org.aoju.bus.setting.metric.GroupMap;

public class Readers {
    private static final char COMMENT_FLAG_PRE = '#';
    private static final char ASSIGN_FLAG = '=';
    private String reg_var = "\\$\\{(.*?)\\}";
    private Charset charset;
    private boolean isUseVariable;
    private GroupMap groupMap;
    private Factory formatterFactory;
    private Supplier<ElementFormatter<IniComment>> commentElementFormatterSupplier = CommentFormatter::new;
    private Supplier<ElementFormatter<IniSection>> sectionElementFormatterSupplier = SectionFormatter::new;
    private Supplier<ElementFormatter<IniProperty>> propertyElementFormatterSupplier = PropertyFormatter::new;

    public Readers() {
        this.formatterFactory = DefaultFormatter::new;
    }

    public Readers(Factory formatterFactory) {
        this.formatterFactory = formatterFactory;
    }

    public Readers(GroupMap groupMap) {
        this(groupMap, org.aoju.bus.core.lang.Charset.UTF_8, false);
    }

    public Readers(GroupMap groupMap, Charset charset, boolean isUseVariable) {
        this.groupMap = groupMap;
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    public boolean load(Resource resource) {
        if (null == resource) {
            throw new NullPointerException("Null setting url define!");
        }
        Logger.debug((String)"Load setting file [{}]", (Object[])new Object[]{resource});
        try {
            InputStream settingStream = resource.getStream();
            this.load(settingStream);
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Load setting error!", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream inputStream) throws IOException {
        this.groupMap.clear();
        BufferedReader reader = null;
        try {
            String line;
            reader = IoKit.getReader((InputStream)inputStream, (Charset)this.charset);
            String group = null;
            while (null != (line = reader.readLine())) {
                if (StringKit.isBlank((CharSequence)(line = line.trim())) || StringKit.startWith((CharSequence)line, (char)'#')) continue;
                if (StringKit.isSurround((CharSequence)line, (CharSequence)"[", (CharSequence)"]")) {
                    group = line.substring(1, line.length() - 1).trim();
                    continue;
                }
                String[] keyValue = StringKit.splitToArray((CharSequence)line, (char)'=', (int)2);
                if (keyValue.length < 2) continue;
                String value = keyValue[1].trim();
                if (this.isUseVariable) {
                    value = this.replaceVar(group, value);
                }
                this.groupMap.put(group, keyValue[0].trim(), value);
            }
        }
        catch (Throwable throwable) {
            IoKit.close(reader);
            throw throwable;
        }
        IoKit.close((Closeable)reader);
        return true;
    }

    public void setVarRegex(String regex) {
        this.reg_var = regex;
    }

    public void store(String absolutePath) {
        this.store(FileKit.touch((String)absolutePath));
    }

    public void store(File file) {
        Assert.notNull((Object)file, (String)"File to store must be not null !", (Object[])new Object[0]);
        Logger.debug((String)"Store Setting to [{}]...", (Object[])new Object[]{file.getAbsolutePath()});
        PrintWriter writer = null;
        try {
            writer = FileKit.getPrintWriter((File)file, (Charset)this.charset, (boolean)false);
            this.store(writer);
        }
        catch (Throwable throwable) {
            IoKit.close(writer);
            throw throwable;
        }
        IoKit.close((Closeable)writer);
    }

    private void store(PrintWriter writer) {
        for (Map.Entry groupEntry : this.groupMap.entrySet()) {
            writer.println(StringKit.format((String)"{}{}{}", (Object[])new Object[]{"[", groupEntry.getKey(), "]"}));
            for (Map.Entry entry : ((LinkedHashMap)groupEntry.getValue()).entrySet()) {
                writer.println(StringKit.format((String)"{} {} {}", (Object[])new Object[]{entry.getKey(), Character.valueOf('='), entry.getValue()}));
            }
        }
    }

    private String replaceVar(String group, String value) {
        Set vars = (Set)PatternKit.findAll((String)this.reg_var, (String)value, (int)0, new HashSet());
        for (String var : vars) {
            String key = PatternKit.get((String)this.reg_var, (String)var, (int)1);
            if (!StringKit.isNotBlank((CharSequence)key)) continue;
            String varValue = this.groupMap.get(group, key);
            if (null != varValue) {
                value = value.replace(var, varValue);
                continue;
            }
            List groupAndKey = StringKit.split((CharSequence)key, (char)'.', (int)2);
            if (groupAndKey.size() <= 1 || null == (varValue = this.groupMap.get((String)groupAndKey.get(0), (String)groupAndKey.get(1)))) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }

    protected Format getFormatter() {
        return this.formatterFactory.apply(this.commentElementFormatterSupplier.get(), this.sectionElementFormatterSupplier.get(), this.propertyElementFormatterSupplier.get());
    }

    public IniSetting read(InputStream in) throws IOException {
        return this.read(new InputStreamReader(in));
    }

    public IniSetting read(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            IniSetting iniSetting = this.read(reader);
            return iniSetting;
        }
    }

    public IniSetting read(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            IniSetting iniSetting = this.read(reader);
            return iniSetting;
        }
    }

    public IniSetting read(Reader reader) throws IOException {
        BufferedReader bufReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return this.bufferedRead(bufReader);
    }

    protected IniSetting defaultFormat(Reader reader) throws IOException {
        return this.defaultFormat(reader, 16);
    }

    protected IniSetting defaultFormat(Reader reader, int builderCapacity) throws IOException {
        int ch;
        Format format = this.getFormatter();
        ArrayList<IniElement> iniElements = new ArrayList<IniElement>();
        String newLineSplit = System.getProperty("line.separator", "\n");
        StringBuilder line = new StringBuilder(builderCapacity);
        while ((ch = reader.read()) != -1) {
            line.append((char)ch);
            String nowStr = line.toString();
            if (!nowStr.endsWith(newLineSplit)) continue;
            IniElement element = format.formatLine(nowStr);
            if (null != element) {
                iniElements.add(element);
            }
            line.delete(0, line.length());
        }
        if (line.length() > 0) {
            iniElements.add(format.formatLine(line.toString()));
        }
        return new IniSetting((Collection<? extends IniElement>)iniElements);
    }

    private IniSetting bufferedRead(BufferedReader reader) throws IOException {
        return this.defaultFormat(reader);
    }

    public Supplier<ElementFormatter<IniComment>> getCommentElementFormatterSupplier() {
        return this.commentElementFormatterSupplier;
    }

    public void setCommentElementFormatterSupplier(Supplier<ElementFormatter<IniComment>> commentElementFormatterSupplier) {
        this.commentElementFormatterSupplier = commentElementFormatterSupplier;
    }

    public Supplier<ElementFormatter<IniSection>> getSectionElementFormatterSupplier() {
        return this.sectionElementFormatterSupplier;
    }

    public void setSectionElementFormatterSupplier(Supplier<ElementFormatter<IniSection>> sectionElementFormatterSupplier) {
        this.sectionElementFormatterSupplier = sectionElementFormatterSupplier;
    }

    public Supplier<ElementFormatter<IniProperty>> getPropertyElementFormatterSupplier() {
        return this.propertyElementFormatterSupplier;
    }

    public void setPropertyElementFormatterSupplier(Supplier<ElementFormatter<IniProperty>> propertyElementFormatterSupplier) {
        this.propertyElementFormatterSupplier = propertyElementFormatterSupplier;
    }
}

