/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.magic;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringJoiner;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.setting.magic.IniElement;
import org.aoju.bus.setting.magic.IniProperty;
import org.aoju.bus.setting.magic.Properties;

public class IniSetting
extends ArrayList<IniElement> {
    public IniSetting() {
    }

    public IniSetting(int initialCapacity) {
        super(initialCapacity);
    }

    public IniSetting(Collection<? extends IniElement> c) {
        super(c);
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        String newLineSplit = this.getNewLineSplit();
        StringJoiner joiner = new StringJoiner(newLineSplit);
        for (IniElement iniElement : this) {
            joiner.add(null == iniElement ? "" : iniElement.toString());
        }
        return joiner.toString();
    }

    private String getNewLineSplit() {
        return System.getProperty("line.separator", "\n");
    }

    public Properties toProperties(String delimiter) {
        Properties prop = new Properties();
        for (IniElement next : this) {
            if (!next.isProperty()) continue;
            IniProperty inip = (IniProperty)next;
            String pk = null != delimiter ? inip.getSection().value() + delimiter + inip.key() : inip.key();
            prop.setProperty(pk, next.value());
        }
        return prop;
    }

    public Properties toProperties() {
        return this.toProperties(".");
    }

    public void write(OutputStream out, java.nio.charset.Charset charset, boolean withComment) throws IOException {
        for (IniElement element : this) {
            if (!withComment && element.isComment()) continue;
            String text = null == element ? this.getNewLineSplit() : (withComment ? element + this.getNewLineSplit() : element.toNoCommentString() + this.getNewLineSplit());
            out.write(text.getBytes(charset));
        }
        out.flush();
    }

    public void write(OutputStream out, boolean withComment) throws IOException {
        this.write(out, Charset.UTF_8, withComment);
    }

    public void write(Writer writer, boolean withComment) throws IOException {
        for (IniElement element : this) {
            if (!withComment && element.isComment()) continue;
            String text = null == element ? this.getNewLineSplit() : (withComment ? element + this.getNewLineSplit() : element.toNoCommentString() + this.getNewLineSplit());
            writer.write(text);
        }
        writer.flush();
    }

    public void write(PrintStream print, boolean withComment) {
        for (IniElement element : this) {
            if (!withComment && element.isComment()) continue;
            String text = null == element ? "" : (withComment ? element.toString() : element.toNoCommentString());
            print.println(text);
        }
        print.flush();
    }

    public void write(File file, java.nio.charset.Charset charset, boolean withComment) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            this.write(out, charset, withComment);
        }
    }

    public void write(File file, boolean withComment) throws IOException {
        this.write(file, Charset.UTF_8, withComment);
    }

    public void write(Path path, java.nio.charset.Charset charset, boolean withComment) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            this.write(out, charset, withComment);
        }
    }

    public void write(Path path, boolean withComment) throws IOException {
        this.write(path, Charset.UTF_8, withComment);
    }
}

